package il.ac.wis.cs.s2a.examples.rssnewsticker;

import il.ac.wis.cs.s2a.examples.rssnewsticker.rssutils.RSSList;
import il.ac.wis.cs.s2a.examples.rssnewsticker.rssutils.RSSParser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;

import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;


public class RSSDisplayFrame extends JFrame implements ActionListener
{
//	static final private int DEFAULT_FEED_INTERVAL = 5000; - Not in use when run by MUSD
//	private RSSFeedTickerTimer feedTimer; - Not in use when run by MUSD
	
	private static final String MI_VERTICAL = "vertical";
	public static final String MI_HORIZONTAL = "horizontal";
	private static final String MI_SLOW = "slow";
	private static final String MI_FAST = "fast";
	private static final String MI_MEDIUM = "medium";
	private static final String MI_SETRSS = "setrss";
	private static final String MI_ABOUT = "about";
	private static final int HORIZONTAL_SPEED = 25;
	private static final int VERTICAL_SPEED = 35;
	public static final int HOR = 0;
	private static final int VER = 1;
	private static final long serialVersionUID = 1L;
	public static String currentAddress;
	
	private RSSDisplay rssDisplay;
	private ScrollTickerTimer scrollingTimer;
	
	private RSSList currentList;
	private MouseListener popupListener;
	private int orientation;
	private Blinker blinker;
	
	public RSSDisplayFrame(RSSList list,String address)
	{
		super("NewsTicker: " + list.getTitle());
		//init(list,address);// This will be execute by the coordinator
		//feedTimer.start();// This will be execute by the coordinator
	}
	
	public void init(RSSList list,String address)
	{
		setSize(502,50);
		currentList = list;
		currentAddress = address;
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setResizable(false);
		getContentPane().setForeground(Color.black);
		setVisible(true);
		initPopupMenu();
		changeOrientation(HOR);
		RSSFeedTickerTimer.setFrame(this);
		//feedTimer = new RSSFeedTickerTimer(DEFAULT_FEED_INTERVAL);//,this);// This will be execute by the coordinator
	}
	
	public void setRSSCaptions(RSSList list)
	{
		rssDisplay.setCaptions(list);
		setTitle(list.getTitle());
	}
	
	public void start()
	{
		scrollingTimer.start();
	}
		
	public void actionPerformed(ActionEvent e) 
	{
		String com = e.getActionCommand();
		if(com.equals(MI_SLOW) ||com.equals(MI_MEDIUM)	
				|| com.equals(MI_FAST))
		{
			scrollingTimer.stop();
			setScrollingSpeed(e.getActionCommand());
		}	
		if(com.equals(MI_SETRSS))
			openSetRSSFeedDialog();
		if(com.equals(MI_ABOUT))
		{
			String about = "RSS News Ticker\nConstructed using the S2A Compiler, September 2006\n" +
	  		"http://www.wisdom.weizmann.ac.il/~maozs/s2a/"; 
			JOptionPane.showMessageDialog(this,
					about,"About RSS News Ticker" , JOptionPane.INFORMATION_MESSAGE);
		}
		if(com.equals(MI_HORIZONTAL))
		{
			
			if(orientation==HOR)
				return;
			changeOrientation(HOR);
			scrollingTimer.start();
		}
		if(com.equals(MI_VERTICAL))
		{
			if(orientation==VER)
				return;
			changeOrientation(VER);
			scrollingTimer.start();
		}		
	}
	
	public void updateRSSCaptions()
	{
		updateRSSCaptions(currentAddress);
	}
	
	public void blinkingStarted() {
		//System.out.println("**** blinkingStarted");
	}
	
	public void blinkingEnded() {
		//System.out.println("**** blinkingEnded");
		blinker.setBackground(Color.green); //TODO: set according to success / failure
	}
	
	RSSDisplay getRSSDisplay()
	{
		return rssDisplay;
	}
	
	private JPopupMenu initPopupMenu()
	{
		JPopupMenu men = new JPopupMenu();
		JMenuItem menuItem;
		menuItem = new JMenuItem("Set RSS Feed...");
		menuItem.addActionListener(this);
		menuItem.setActionCommand(MI_SETRSS);
		men.add(menuItem);
		men.addSeparator();
		JMenu submenu = new JMenu("Scroll Direction");
		JMenuItem horizontal = new JMenuItem("Horizontal");
		JMenuItem vertical = new JMenuItem("Vertical");
		horizontal.addActionListener(this);
		vertical.addActionListener(this);
		horizontal.setActionCommand(MI_HORIZONTAL);
		vertical.setActionCommand(MI_VERTICAL);
		submenu.add(horizontal);
		submenu.add(vertical);
		men.add(submenu);	
		JMenu submenuScroll = new JMenu("Scroll Speed");
		JMenuItem slow = new JMenuItem("Slow");
		JMenuItem medium = new JMenuItem("Medium");
		JMenuItem fast = new JMenuItem("Fast");
		slow.addActionListener(this);
		medium.addActionListener(this);
		fast.addActionListener(this);
		slow.setActionCommand(MI_SLOW);
		medium.setActionCommand(MI_MEDIUM);
		fast.setActionCommand(MI_FAST);
		submenuScroll.add(slow);
		submenuScroll.add(medium);
		submenuScroll.add(fast);
		men.add(submenuScroll);	
		men.addSeparator();
		JMenuItem about = new JMenuItem("About...");
		about.addActionListener(this);
		about.setActionCommand(MI_ABOUT);
		men.add(about);	
        popupListener = new PopupListener(men);
        addMouseListener(popupListener);
		return men;
	}
	
	private void openSetRSSFeedDialog()
	{
		String s = (String)JOptionPane.showInputDialog(
		                    this,
		                    "Site: ",
		                    "Set RSS Feed",
		                    JOptionPane.PLAIN_MESSAGE,
		                    null,
		                    null,
		                    currentAddress);
		if ((s != null) && (s.length() > 0))
			updateRSSCaptions(s);

	}
	
	private void updateRSSCaptions(String address)
	{
		currentAddress = address;
		RSSFeedThread t = new RSSFeedThread(address,this);
		t.start();
		blinker.startBlinking();
	}
	
	private void setScrollingSpeed(String speed)
	{
		//Empty Used by the MUSD
	}
	
	private void changeOrientation(int or)
	{
		if(rssDisplay!=null)//First time it is still null
			remove(rssDisplay);
		if(or==HOR)
		{
			rssDisplay = new HorizontalRSSDisplay();
			orientation = HOR;
			scrollingTimer = new ScrollTickerTimer(HORIZONTAL_SPEED,rssDisplay);
			MSDEnv.setDisplay(rssDisplay);
		}
		else
		{
			rssDisplay = new VerticalRSSDisplay();
			orientation = VER;
			scrollingTimer = new ScrollTickerTimer(VERTICAL_SPEED,rssDisplay);
			MSDEnv.setDisplay(rssDisplay);
		}
		getContentPane().add(rssDisplay,BorderLayout.CENTER);
		setRSSCaptions(currentList);
		MSDEnv.setDisplay(rssDisplay);
		blinker = new Blinker();
		getContentPane().add(blinker,BorderLayout.PAGE_END);
		blinker.setSize(rssDisplay.getWidth(),1);	
		setSize(rssDisplay.getWidth()+2,(rssDisplay.getHeight()+42));
		setVisible(true);
		rssDisplay.addMouseListener(popupListener);
	}
	
	public boolean isRSSFrameActivated()
	{
		return true;
	}
	
	
}
