package il.ac.wis.cs.s2a.examples.rssnewsticker;

import il.ac.wis.cs.s2a.examples.rssnewsticker.rssutils.RSSItem;
import il.ac.wis.cs.s2a.examples.rssnewsticker.rssutils.RSSList;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Iterator;

import javax.swing.JPanel;


public abstract class RSSDisplay extends JPanel 
				implements MouseListener,MouseMotionListener
{
	
	private static final long serialVersionUID = 1L;
	final static int MAX_SIZE = 100;
	final static Cursor HAND = new Cursor(Cursor.HAND_CURSOR);
	final static Cursor DEFAULT = new Cursor(Cursor.DEFAULT_CURSOR);
	final static int WIDTH =500;
	final static int HEIGHT=25;
	String browserPath = NewsTickerApp.browserPath;//"C:\\Program Files\\Internet Explorer\\IEXPLORE.EXE";

	int xx; // text location
	int ntext; // number of text
	int text_width; // text width
	int fontsize; // size of font
	int mouse_x; // mouse x coordinate
	int mouse_y; // mouse y coordinate
	int selected; // selected caption
	String[] captions; // captions
	String[] url; // urls
	Font font; // font face
	FontMetrics fm; // font metrics
	Color fgcolor, bgcolor, accolor;
	Image offscrImg; // double buffer image
	Graphics offscr; // double buffer graphics

	public RSSDisplay() 
	{
		captions = new String[MAX_SIZE];
		url = new String[MAX_SIZE];
		fontsize = this.getFont().getSize();
		fgcolor = Color.white;
		bgcolor = Color.black;
		accolor = Color.green;
		font = new Font("Times Roman", Font.PLAIN, 12);
		addMouseListener(this);
		addMouseMotionListener(this);
	}

	public void setCaptions(RSSList list)
	{
		offscrImg = createImage(getWidth(), getHeight());
		offscr = offscrImg.getGraphics();
		fm = offscr.getFontMetrics(font);
		ntext = text_width = xx = 0;
		Iterator<RSSItem> it = list.getIterator();
		RSSItem item;
		while(it.hasNext())
		{
			item = it.next();
			captions[ntext] = item.getTitle();
			url[ntext] = item.getLink().toString();
			text_width += fm.stringWidth(captions[ntext]) + 20;
			ntext++;
		}
		mouse_x = mouse_y = -text_width;	
	}
	
	public void update(Graphics g)
	{
		paint(g);
	}
	
	public void move()
	{
		repaint();
	}

	public void mouseClicked(MouseEvent arg0)
	{
		if(arg0.getButton()==MouseEvent.BUTTON3)
			return;
		if (selected != -1 && url[selected] != null)
		{
			try 
			{
				String cmd[] ={browserPath,url[selected]};
				Runtime.getRuntime().exec(cmd);
			}
			catch (Exception e) 
			{
				System.out.println(e.toString());
				System.out.println(e.getMessage());
			}
		}		
	}

	public void mouseEntered(MouseEvent evt) 
	{
		mouse_x = evt.getX();
		mouse_y = evt.getY();
	}
	
	public void mouseMoved(MouseEvent evt)
	{
		mouse_x = evt.getX();
		mouse_y = evt.getY();		
	}

	public void mouseExited(MouseEvent evt)
	{
		mouse_x = evt.getX();
		mouse_y = evt.getY();
	}

	public void mousePressed(MouseEvent arg0) 
	{
		mouse_x = arg0.getX();
		mouse_y = arg0.getY();	
	}

	public void mouseReleased(MouseEvent arg0) 
	{
		mouse_x = arg0.getX();
		mouse_y = arg0.getY();			
	}

	public void mouseDragged(MouseEvent e) {
		mouse_x = e.getX();
		mouse_y = e.getY();
	}
}
