//  The file MSDCoordinatorAspect.aj was automatically generated using S2A 0.6 beta.
//	 Usage of the generated code is permitted for non-commercial research and evaluation purposes..
//	 Removing or changing the above comment is prohibited by S2A 0.6 beta license agreement.
//	 For information see http://www.wisdom.weizmann.ac.il/~maozs/s2a/

package pacman.aspects;

import pacman.classes.*;
import il.ac.wis.cs.s2a.runtime.lib.*;


public aspect MSDCoordinatorAspect
{
	declare precedence: MSDCoordinatorAspect, *;
	ICoordinatorStrategy strategy = new CoordinatorStrategyNaiveImpl();

	private boolean lock = false;
	private int counter = 0;

	pointcut MSDMessage():
	call(void GameControl.playerEaten(..))
	|| call(void GameModel.setHighScore(..))
	|| call(void GameModel.setVisibleThings(..))
	|| call(void GameModel.doubleGhostScore(..))
	|| call(void GameControl.ghostSlowedDown(..))
	|| execution(void Ghost.speedUp(..))
	|| call(void Player.decreaseLivesNumber(..))
	|| call(void GameModel.leavingJail(..))
	|| call(void GameControl.fruitEaten(..))
	|| call(void GameModel.enteringJail(..))
	|| call(void Player.eatFruit(..))
	|| execution(void Ghost.setNormalShape(..))
	|| execution(void Fruit.enterScreen(..))
	|| call(int GameModel.getFruitScore(..))
	|| call(void Ghost.pacmanAtePowerup(..))
	|| call(void GameModel.levelComplete(..))
	|| call(void Player.eatGhost(..))
	|| execution(void Ghost.stopFleeing(..))
	|| call(void GameModel.pacmanWasEaten(..))
	|| call(void GameModel.gameOver(..))
	|| call(void GameModel.setPausedGame(..))
	|| call(void Player.checkHighScore(..))
	|| call(void Fruit.eatenByPacman(..))
	|| call(void GameModel.pacmanAtePowerup(..))
	|| call(void Ghost.collidedWithPacman(..))
	|| call(void Ghost.eatenByPacman(..))
	|| call(void GameUI.setRedraw(..))
	|| call(void GameModel.restartGame(..))
	|| execution(void Ghost.slowDown(..))
	|| execution(void Ghost.goToJail(..))
	|| call(void Player.increaseScore(..))
	|| call(void GameControl.ghostStoppedFleeing(..))
	|| execution(void GameModel.resetGhostPoints(..))
	|| execution(void Ghost.leaveJail(..))
	|| call(void GameControl.powerUpEaten(..))
	|| call(void Player.eatenByGhost(..))
	|| call(void GameModel.loadNextLevel(..))
	|| call(int GameModel.getGhostScore(..))
	|| execution(void Ghost.setEyesOnly(..))
	|| call(void Ghost.eatPacman(..))
	|| call(int GameModel.getHighScore(..));


	after (): MSDMessage()
	{
		MSDAspect.handlingEvent(thisJoinPoint);
		coordinate();
	}

	private void coordinate()
	{
		if (lock)
		{
			counter++;
			return;
		}
		else
		{
			lock = true;
			afterImpl();
			lock = false;
		}
		if(counter>0)
		{
			counter--;
			coordinate();
		}
	}

	private void afterImpl() 
	{
		MSDMethodSet monitoringEnabled = new MSDMethodSet();
		MSDMethodSet executingEnabled = new MSDMethodSet();
		MSDMethodSet coldViolation = new MSDMethodSet();
		MSDMethodSet hotViolation = new MSDMethodSet();

		MSDAspectPacmanEatsGhost.aspectOf().getCutState(monitoringEnabled, executingEnabled, coldViolation, hotViolation);
		MSDAspectGhostEatsPacman.aspectOf().getCutState(monitoringEnabled, executingEnabled, coldViolation, hotViolation);
		MSDAspectPacmanEatsFruit.aspectOf().getCutState(monitoringEnabled, executingEnabled, coldViolation, hotViolation);
		MSDAspectLevelComplete.aspectOf().getCutState(monitoringEnabled, executingEnabled, coldViolation, hotViolation);
		MSDAspectHighScoresUpdate.aspectOf().getCutState(monitoringEnabled, executingEnabled, coldViolation, hotViolation);
		MSDAspectPowerUpEaten.aspectOf().getCutState(monitoringEnabled, executingEnabled, coldViolation, hotViolation);
		MSDAspectGhostFleeing.aspectOf().getCutState(monitoringEnabled, executingEnabled, coldViolation, hotViolation);
		MSDAspectGhostStopsFleeing.aspectOf().getCutState(monitoringEnabled, executingEnabled, coldViolation, hotViolation);
		MSDAspectGhostEaten.aspectOf().getCutState(monitoringEnabled, executingEnabled, coldViolation, hotViolation);

		MSDMethod MSDm = strategy.chooseMethod(monitoringEnabled, executingEnabled, coldViolation, hotViolation);

		if(MSDm != null)
		{
			switch (MSDm.messageID)
			{
			}
		}
	}
}

