/**
 * MemoryApplication.java
 **/
package il.ac.wis.cs.s2a.examples.memoryGame.classes;

import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

/**
 * MemoryApplication wraps a MemoryPanel for the Memory game.
 **/
public class MemoryApplication
{

  public static void main( String[] args )
  {
    JFrame memoryFrame = new JFrame( "Memory Game" );
    JMenuBar bar = new JMenuBar();
    JMenu menu = new JMenu("Game");
    JMenuItem about = new JMenuItem("About");
    JMenuItem newGame = new JMenuItem("New Game");
    about.setActionCommand("about");
    menu.add(newGame);
    menu.add(about);
    bar.add(menu);
    memoryFrame.setJMenuBar(bar);
    MemoryPanel memoryPanel = new MemoryPanel();
    memoryFrame.getContentPane().add(memoryPanel);
    newGame.setActionCommand(MemoryPanel.NEW_GAME);
    about.setActionCommand(MemoryPanel.ABOUT);
    about.addActionListener(memoryPanel);
    newGame.addActionListener(memoryPanel);
    memoryFrame.setSize( 500, 500 );
    memoryFrame.setDefaultCloseOperation( JFrame.EXIT_ON_CLOSE );
    memoryFrame.setVisible( true );
  }
}
