package il.ac.wis.cs.s2a.examples.phonebook.model;

import il.ac.wis.cs.s2a.examples.phonebook.PhoneBookConstants;
import il.ac.wis.cs.s2a.examples.phonebook.PhoneBookView;
import il.ac.wis.cs.s2a.runtime.lib.IPart;

/**
 * Part-of the Phone Book model. 
 * Controlls the model's operations.
 * @author asafk
 *
 */
public class ModelControll implements IPart 
{
	private PhoneBookView phonebookview;
	private int state = PhoneBookConstants.STATE_IDLE;
	private PhoneBookModel owner;
	
	ModelControll(PhoneBookModel model)
	{
		owner = model;		
	}
	
	public void setState(int aState)
	{
		state = aState;	
	}
	
	public void setView(PhoneBookView view)
	{
		phonebookview = view;
	}

	public int getState() 
	{
		return state;
	}
	
	public Object getOwner()
	{
		return owner;
	}

	public void start() 
	{
		setState(PhoneBookConstants.STATE_IDLE);
		phonebookview.stateHasChanged(state);
	}
}
