package il.ac.wis.cs.s2a.examples.phonebook.view.extended;

import il.ac.wis.cs.s2a.runtime.lib.IPart;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JTextField;
import javax.swing.text.BadLocationException;



public class ExtendedInputPane extends JTextField implements ActionListener,IPart
{
	private static final long serialVersionUID = 1L;
	
	private ExtendedViewController viewControll;
	
	public ExtendedInputPane(int i)
	{
		super(i);
		setEnabled(false);
	}
	
	public void setViewControll(ExtendedViewController controll)
	{
		viewControll = controll;
	}
	
	public void setEnabled(boolean enabled)
	{
		setEditable(enabled);
		if(enabled)
			addActionListener(this);
		else
			removeActionListener(this);
	}
	
	public void actionPerformed(ActionEvent evt) 
	{
		String answer = getText();	
		int len = getDocument().getLength();
		try {
			getDocument().remove(0, len);
		} catch (BadLocationException e) {
			e.printStackTrace();
		}
		viewControll.userHasInput(answer);
		viewControll.userHasInput2(answer);
	}

	public Object getOwner()
	{
		return viewControll.getOwner();
	}
}

