//  The file MSDCoordinatorAspect.aj was automatically generated using S2A 0.6 beta.
//	 Usage of the generated code is permitted for non-commercial research and evaluation purposes..
//	 Removing or changing the above comment is prohibited by S2A 0.6 beta license agreement.
//	 For information see http://www.wisdom.weizmann.ac.il/~maozs/s2a/

package il.ac.wis.cs.s2a.examples.memoryGame.aspects;

import il.ac.wis.cs.s2a.examples.memoryGame.classes.*;
import il.ac.wis.cs.s2a.runtime.lib.*;


public aspect MSDCoordinatorAspect
{
	declare precedence: MSDCoordinatorAspect, *;
	ICoordinatorStrategy strategy = new CoordinatorStrategyNaiveImpl();

	private boolean lock = false;
	private int counter = 0;

	public void MemoryCard.WrapperreDraw(MemoryCard memoryCard)
	{
		memoryCard.reDraw();
	}

	public void MemoryPanel.WrapperflipDown(MemoryCard memoryCard)
	{
		memoryCard.flipDown();
	}

	public void MemoryPanel.WrappersoundBeep(MemoryPanel memoryPanel)
	{
		memoryPanel.soundBeep();
	}

	public void MemoryPanel.WrapperflipUp(MemoryCard memoryCard)
	{
		memoryCard.flipUp();
	}

	pointcut MSDMessage():
	call(void MemoryCard.flipDown(..))
	|| execution(void MemoryCard.mouseClicked(..))
	|| execution(void MemoryPanel.soundBeep(..))
	|| execution(void MemoryCard.reDraw(..))
	|| call(void MemoryCard.flipUp(..));


	after (): MSDMessage()
	{
		MSDAspect.handlingEvent(thisJoinPoint);
		coordinate();
	}

	private void coordinate()
	{
		if (lock)
		{
			counter++;
			return;
		}
		else
		{
			lock = true;
			afterImpl();
			lock = false;
		}
		if(counter>0)
		{
			counter--;
			coordinate();
		}
	}

	private void afterImpl() 
	{
		MSDMethodSet monitoringEnabled = new MSDMethodSet();
		MSDMethodSet executingEnabled = new MSDMethodSet();
		MSDMethodSet coldViolation = new MSDMethodSet();
		MSDMethodSet hotViolation = new MSDMethodSet();

		MSDAspectFlipUp.aspectOf().getCutState(monitoringEnabled, executingEnabled, coldViolation, hotViolation);
		MSDAspectMatch.aspectOf().getCutState(monitoringEnabled, executingEnabled, coldViolation, hotViolation);
		MSDAspectReDraw.aspectOf().getCutState(monitoringEnabled, executingEnabled, coldViolation, hotViolation);

		MSDMethod MSDm = strategy.chooseMethod(monitoringEnabled, executingEnabled, coldViolation, hotViolation);

		if(MSDm != null)
		{
			switch (MSDm.messageID)
			{
				case MSDMethods.MemoryCard_MemoryCard_reDraw:
				 ((MemoryCard)MSDm.sourceInstance).WrapperreDraw(
					(MemoryCard)MSDm.targetInstance);
				break;
				case MSDMethods.MemoryPanel_MemoryCard_flipDown:
				 ((MemoryPanel)MSDm.sourceInstance).WrapperflipDown(
					(MemoryCard)MSDm.targetInstance);
				break;
				case MSDMethods.MemoryPanel_MemoryPanel_soundBeep:
				 ((MemoryPanel)MSDm.sourceInstance).WrappersoundBeep(
					(MemoryPanel)MSDm.targetInstance);
				break;
				case MSDMethods.MemoryPanel_MemoryCard_flipUp:
				 ((MemoryPanel)MSDm.sourceInstance).WrapperflipUp(
					(MemoryCard)MSDm.targetInstance);
				break;
			}
		}
	}
}

