package il.ac.wis.cs.s2a.runtime.lib;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

import org.aspectj.lang.JoinPoint;

/**
 * Aspect for monitoring. Generates 'scenario-based trace' log.
 * 
 * @author Shahar Maoz
 */
public aspect MSDMonitor {
	private static final String PROPERTIES_FILE_NAME = "resources/musdmonitor.properties";

	private static final String MONITOR_LEVEL = "monitorLevel";

	private static final String MONITOR_OUTPUT = "monitorOutput";

	private static final String TO_MONITOR_INTERACTIONS = "interactions";

	private static final String APPEND = "append";

	private static final String HOT = "Hot";

	private static final String COLD = "Cold";

	private static final String VIOLATION = "Violation";

	private static final String COMPLETION = "Completion";

	private static int monitorLevel = 0;

	private static long eventNumber = 0;// Events counter

	private static String monitorOutput;

	private static PrintWriter out;

	private static String toMonitorInterations[];

	private static boolean append = true;

	private static boolean eventFlag = false;

	private static ArrayList<String> cutStrings;

	private static ArrayList<String> bindingStrings = new ArrayList<String>();

	MSDMonitor() {
		File file = new File(PROPERTIES_FILE_NAME);
		/*
		 * System.out.println("properties file path is: "+PROPERTIES_FILE_NAME);
		 * System.out.println("current directory is:
		 * "+System.getProperty("user.dir"));
		 */if (file.isFile()) {
			Properties properties = new Properties();
			try {
				FileInputStream in = new FileInputStream(PROPERTIES_FILE_NAME);
				properties.load(in);
				monitorLevel = Integer.parseInt(properties
						.getProperty(MONITOR_LEVEL));
				monitorOutput = properties.getProperty(MONITOR_OUTPUT);
				toMonitorInterations = properties.getProperty(
						TO_MONITOR_INTERACTIONS).split(";");
				String appendString = properties.getProperty(APPEND);
				if (appendString != null && appendString.trim().equals("false"))
					append = false;
				out = new PrintWriter(new FileWriter(monitorOutput, append));
			} catch (NumberFormatException e) {
				monitorLevel = 0;
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	private boolean isInteractionLogged(String interName) {
		if (toMonitorInterations == null || toMonitorInterations.length == 0)
			return false;
		if (toMonitorInterations[0].equals("*"))
			return true;
		String s = getInteractionName(interName);
		for (int i = 0; i < toMonitorInterations.length; i++)
			if (toMonitorInterations[i].trim().equals(s))
				return true;
		return false;
	}

	private String getInteractionName(String name) {
		int last = name.lastIndexOf(".");
		if (last == -1)
			return name;
		return name.substring(last + ".MUSDAspect".length() - 1);
	}

	pointcut aspectStaticCreation(MSDAspect musdAspect):
		execution(MSDAspect.new(..)) && target(musdAspect)
		&& if(monitorLevel>0);

	after(MSDAspect musdAspect):aspectStaticCreation(musdAspect)
	{
		String name = musdAspect.getClass().getName();
		if (isInteractionLogged(name))
			;
		// out(getInteractionName(name)+ " Static initialization.");
	}

	pointcut activeAspectCreation(MSDAspect.ActiveMSDAspect activeMUSD):
		execution(MSDAspect.ActiveMSDAspect.new(..)) 
		&& target(activeMUSD) && if(monitorLevel>0);

	after(MSDAspect.ActiveMSDAspect activeMUSD):
		activeAspectCreation(activeMUSD)
	{
		String name = activeMUSD.getOwner().getClass().getName();
		if (isInteractionLogged(name)) {
			// Getting the number of lifelines for this activeMSD
			Integer num = (Integer) thisJoinPoint.getArgs()[1];
			long id = activeMUSD.getId();
			StringBuffer str = new StringBuffer();
			str.append(name).append("[").append(id).append("] (0");
			for (int i = 1; i < num; i++)
				str.append(",0");
			str.append(")");
			// out(str.toString());
		}
	}

	pointcut setCut(ArrayList<Integer> setLocations,
			MSDAspect.ActiveMSDAspect activeMUSD):
		execution(void MSDAspect.ActiveMSDAspect._setCut(..))
		&& args(setLocations) && target(activeMUSD) && if(monitorLevel>0);

	after(ArrayList<Integer> setLocations, MSDAspect.ActiveMSDAspect activeMUSD):
		setCut(setLocations,activeMUSD)
	{
		boolean isHot = activeMUSD.getOwner().isHotCut(setLocations);
		String name = activeMUSD.getOwner().getClass().getName();
		if (isInteractionLogged(name)) {
			if (!eventFlag)// Counting Events
			{
				cutStrings = new ArrayList<String>();
				cutStrings.addAll(bindingStrings);
				bindingStrings = new ArrayList<String>();
				eventNumber++;
				eventFlag = true;
			}
			long id = activeMUSD.getId();
			StringBuffer str = new StringBuffer();
			Iterator<Integer> it = setLocations.iterator();
			str.append(name).append("[").append(id).append("] (");
			boolean first = true;
			while (it.hasNext()) {
				if (first)
					str.append(it.next());
				else
					str.append(",").append(it.next());
				first = false;
			}
			String mode = isHot ? HOT : COLD;
			str.append(") ").append(mode);
			outChangeCut(str.toString());
		}
	}

	pointcut activeCompleted(MSDAspect.ActiveMSDAspect activeMUSD):
		execution(void MSDAspect.ActiveMSDAspect.completion()) 
		&& target(activeMUSD) && if(monitorLevel>0);

	after(MSDAspect.ActiveMSDAspect activeMUSD):
		activeCompleted(activeMUSD)
	{
		String name = activeMUSD.getOwner().getClass().getName();
		boolean isViolation = !activeMUSD.isCurrentCutLast();
		if (isInteractionLogged(name)) {
			long id = activeMUSD.getId();
			StringBuffer str = new StringBuffer();
			String exitMode = isViolation ? VIOLATION : COMPLETION;
			str.append(name).append("[").append(id).append("] " + exitMode);
			outCompletion(str.toString());
		}
	}

	pointcut eventFlag(JoinPoint joinPoint): 
		execution(void MSDAspect.handlingEvent(..)) && args(joinPoint);

	after(JoinPoint joinPoint): eventFlag(joinPoint)
	{
		if (eventFlag) {
			out.print("E: " + System.currentTimeMillis() + " " + eventNumber
					+ ": " + joinPoint.getSignature().toString() + " ");
			Object[] args = joinPoint.getArgs();
			for (Object obj : args)
				out.print(obj + " ");
			out.println();
			for (String str : cutStrings)
				out.println(str);
			out.flush();
			eventFlag = false;

		}
	}

	pointcut binding(Object index, Object lifeline,
			MSDAspect.ActiveMSDAspect activeMSD):
		execution(void setLineInstance(..)) && args(index,lifeline)
		&& target(activeMSD);

	void around(Object _index, Object lifeline,
			MSDAspect.ActiveMSDAspect activeMSD):
		binding(_index,lifeline,activeMSD)
	{
		int index = (Integer) _index;
		String name = activeMSD.getOwner().getClass().getName();
		long id = activeMSD.getId();
		boolean firstBindingFlag = activeMSD.instancesEquals(index, null);
		proceed(_index, lifeline, activeMSD);
		if ((isInteractionLogged(name))
				&& (firstBindingFlag && lifeline != null)) {
			StringBuffer str = new StringBuffer();
			index = (Integer) _index;
			str.append(name).append("[").append(id).append("] ");
			str.append("lifeline " + index + " <- " + lifeline);
			outBindings(str.toString());
		}
	}

	private void outChangeCut(String s) {
		StringBuffer str = new StringBuffer();
		str.append("C: " + s);
		cutStrings.add(str.toString());
	}

	private void outCompletion(String s) {
		StringBuffer str = new StringBuffer();
		str.append("F: " + s);
		cutStrings.add(str.toString());
	}

	private void outBindings(String s) {
		StringBuffer str = new StringBuffer();
		// str.append(System.currentTimeMillis()+ " ");
		str.append("B: " + s);
		bindingStrings.add(str.toString());
	}
}
