package il.ac.wis.cs.s2a.examples.mvc.interfaces;

/**
 * Classes that implementes this interface should play
 * the role of the View in the Model-View-Controller design pattern.
 * The View usually renders the model into a form suitable for interaction,
 * typically a user interface element.
 */
public interface IView 
{
	/**
     * Called by the model when the state has been changed
     * @param newState
     */
    public void stateHasChanged(int newState);

    /**
	 * Changes the view based on the new state.
	 * @param newState
	 */
	public void changeView(int newState);
}
