package il.ac.wis.cs.s2a.examples.phonebook;

import il.ac.wis.cs.s2a.examples.mvc.interfaces.IView;

/**
 * Abstract View for the phone book application.
 * Implements the {@link IView} interface.
 * @author Shahar Maoz && Asaf Kleinbort
 */

public abstract class PhoneBookView implements IView 
{
	//Strings used by the command line interface
	private final static String ADD_NAME_Q = "Please enter the exact person name";
	private final static String ADD_NUMBER_Q = "Please enter the phone number";
	private final static String SEARCH_Q = "Please enter the exact person name.";
	private final static String IDLE_Q = "Please type your choice of action:\n\""
		+ PhoneBookConstants.COMMAND_ADD_STRING
		+ "\" to add a phone entry \n\""
		+ PhoneBookConstants.COMMAND_SEARCH_STRING
		+ "\" to search for a phone number \n\""
		+ PhoneBookConstants.COMMAND_QUIT_STRING + "\" to exit.";
	private final static String SEARCH_RESULT = "The phone number is: ";
	private final static String SEARCH_RESULT_Q = "Enter \""
		+ PhoneBookConstants.COMMAND_START_STRING
		+ "\" to do more with the application.\nEnter \""
		+ PhoneBookConstants.COMMAND_QUIT_STRING + "\" to exit.";
	private final static String SEARCH_NOT_FOUND_Q = "Person's phone number not found.\nEnter \""
		+ PhoneBookConstants.COMMAND_START_STRING
		+ "\" to do more with the application.\nEnter \""
		+ PhoneBookConstants.COMMAND_QUIT_STRING + "\" to exit.";
	private final static String ERROR_Q = "You've entered an invalid choice.\nEnter \""
		+ PhoneBookConstants.COMMAND_START_STRING
		+ "\" to do more with the application.\nEnter \""
		+ PhoneBookConstants.COMMAND_QUIT_STRING + "\" to exit.";
	private final static String EXIT = "Thanks for using the application.";

	protected PhoneBookController phonebookcontroller;
	protected String answer;
	
	/**
	 * Called by the model when the state has been changed
	 */
	abstract public void stateHasChanged(int newState);
	
	/**
	 * Displays question and gets user input.
	 */
	abstract protected void getUserInput(String question) ;

	
	public PhoneBookView(PhoneBookController controller) 
	{
		phonebookcontroller = controller;
	}
	/*
	 * Changes the view based on the new state.
	 * @param newState
	 */
	public void changeView(int newState)
	{
		if (newState == PhoneBookConstants.STATE_IDLE) {
			getUserInput(IDLE_Q);
		} else if (newState == PhoneBookConstants.STATE_ADD_NAME) {
			getUserInput(ADD_NAME_Q);
		} else if (newState == PhoneBookConstants.STATE_ADD_NUMBER) {
			getUserInput(ADD_NUMBER_Q);
		} else if (newState == PhoneBookConstants.STATE_SEARCH) {
			getUserInput(SEARCH_Q);
		} else if (newState == PhoneBookConstants.STATE_SEARCH_RESULT) {
			String result = phonebookcontroller.getModel().getSearchResult();
			if (result == null || result.length() == 0) {
				getUserInput(SEARCH_NOT_FOUND_Q);
			} else {
				getUserInput(SEARCH_RESULT + result + "\n" + SEARCH_RESULT_Q);
			}
		} else if (newState == PhoneBookConstants.STATE_ERROR) {
			getUserInput(ERROR_Q);
		} else if (newState == PhoneBookConstants.STATE_EXIT) {
			out(EXIT);
		}
	}
	
	protected void out(String s)
	{
		System.out.println(s);
	}	
}
