/*
 * Decompiled with CFR 0.152.
 */
package memoryGame.classes;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JComponent;
import memoryGame.aspects.MUSDAspectFlipUp;
import memoryGame.aspects.MUSDAspectReDraw;
import memoryGame.aspects.MUSDCoordinatorAspect;
import org.aspectj.internal.lang.annotation.ajcITD;

public class MemoryCard
extends JComponent
implements MouseListener {
    private static final long serialVersionUID = 1L;
    private String description;
    private Color color;
    public boolean faceUp;

    public void test() {
    }

    public MemoryCard(String description, Color color) {
        this.description = description;
        this.color = color;
        this.faceUp = false;
        this.addMouseListener(this);
    }

    public void flipUp() {
        this.faceUp = true;
    }

    public void rePaint() {
        this.repaint(0L);
    }

    public void reDraw() {
        try {
            try {
                try {
                    this.rePaint();
                }
                finally {
                    MUSDAspectFlipUp.aspectOf().ajc$after$memoryGame_aspects_MUSDAspectFlipUp$2$474fd447(this);
                }
            }
            finally {
                MUSDAspectReDraw.aspectOf().ajc$after$memoryGame_aspects_MUSDAspectReDraw$2$474fd447(this);
            }
        }
        finally {
            MUSDCoordinatorAspect.aspectOf().ajc$after$memoryGame_aspects_MUSDCoordinatorAspect$1$96aa1d4f();
        }
    }

    public void mouseClicked(MouseEvent e) {
        try {
            try {
                try {
                }
                finally {
                    MUSDAspectFlipUp.aspectOf().ajc$after$memoryGame_aspects_MUSDAspectFlipUp$1$6bb6408e(this);
                }
            }
            finally {
                MUSDAspectReDraw.aspectOf().ajc$after$memoryGame_aspects_MUSDAspectReDraw$1$6bb6408e(this);
            }
        }
        finally {
            MUSDCoordinatorAspect.aspectOf().ajc$after$memoryGame_aspects_MUSDCoordinatorAspect$1$96aa1d4f();
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    private String getDescription() {
        return this.description;
    }

    private Color getColor() {
        return this.color;
    }

    public boolean isFaceUp() {
        return this.faceUp;
    }

    public boolean match(MemoryCard testCard) {
        return testCard.getDescription().equals(this.description) && testCard.getColor().equals(this.color);
    }

    public void paint(Graphics g) {
        if (this.faceUp) {
            this.paintBackground(g, this.color);
            this.paintDescription(g);
        } else {
            this.paintBackground(g, Color.LIGHT_GRAY);
        }
    }

    private void paintBackground(Graphics g, Color c) {
        g.setColor(c);
        g.fillRoundRect(2, 2, this.getWidth() - 1 - 2, this.getHeight() - 1 - 2, 20, 20);
        g.setColor(Color.black);
        g.drawRoundRect(2, 2, this.getWidth() - 1 - 2, this.getHeight() - 1 - 2, 20, 20);
    }

    private void paintDescription(Graphics g) {
        g.setColor(Color.white);
        g.setFont(new Font("Arial", 1, 24));
        g.drawString(this.description, 10, this.getHeight() / 2 + 5);
    }

    public void flipDown() {
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            public void run() {
                MemoryCard.this.faceUp = false;
                MemoryCard.this.repaint(0L);
            }
        }, 800L);
    }

    @ajcITD(targetType="memoryGame.classes.MemoryCard", name="WrapperreDraw", modifiers=1)
    public void WrapperreDraw(MemoryCard memoryCard) {
        MUSDCoordinatorAspect.ajc$interMethod$memoryGame_aspects_MUSDCoordinatorAspect$memoryGame_classes_MemoryCard$WrapperreDraw(this, memoryCard);
    }
}

