/*
 * Decompiled with CFR 0.152.
 */
package memoryGame.classes;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import memoryGame.aspects.MUSDAspectMatch;
import memoryGame.aspects.MUSDCoordinatorAspect;
import memoryGame.classes.MemoryCard;
import org.aspectj.internal.lang.annotation.ajcITD;

public class MemoryPanel
extends JPanel
implements ActionListener {
    static final String ABOUT = "about";
    static final String NEW_GAME = "new game";
    private static final long serialVersionUID = 1L;
    private static MemoryPanel singleMemoryPanel = null;
    private ArrayList<MemoryCard> cards;
    private Random rand;

    public MemoryPanel() {
        singleMemoryPanel = this;
        this.rand = new Random();
        this.setLayout(new GridLayout(4, 4));
        this.addRandomCards();
    }

    private void addCard(String description, Color color) {
        MemoryCard card = new MemoryCard(description, color);
        this.cards.add(card);
    }

    private void addRandomCards() {
        this.cards = new ArrayList(16);
        this.addCard("Apple", Color.red);
        this.addCard("Orange", Color.red);
        this.addCard("Apple", Color.BLACK);
        this.addCard("Banana", Color.BLACK);
        this.addCard("Peach", Color.red);
        this.addCard("Banana", Color.BLACK);
        this.addCard("Orange", Color.red);
        this.addCard("Peach", Color.BLACK);
        this.addCard("Peach", Color.red);
        this.addCard("Orange", Color.BLACK);
        this.addCard("Banana", Color.red);
        this.addCard("Orange", Color.BLACK);
        this.addCard("Apple", Color.BLACK);
        this.addCard("Peach", Color.BLACK);
        this.addCard("Banana", Color.red);
        this.addCard("Apple", Color.red);
        int j = 16;
        while (j > 0) {
            int index = this.rand.nextInt(j);
            MemoryCard card = this.cards.remove(index);
            this.add(card);
            --j;
        }
        this.validate();
    }

    public static MemoryPanel getMemoryPanel() {
        return singleMemoryPanel;
    }

    public void soundBeep() {
        try {
            try {
                Toolkit.getDefaultToolkit().beep();
            }
            finally {
                MUSDAspectMatch.aspectOf().ajc$after$memoryGame_aspects_MUSDAspectMatch$3$2bfe3729(this);
            }
        }
        finally {
            MUSDCoordinatorAspect.aspectOf().ajc$after$memoryGame_aspects_MUSDCoordinatorAspect$1$96aa1d4f();
        }
    }

    public void actionPerformed(ActionEvent e) {
        String about = "Memory Game\nConstructed using the S2A Compiler, July 2006\nhttp://www.wisdom.weizmann.ac.il/~maozs/s2a/";
        if (e.getActionCommand().equals(ABOUT)) {
            JOptionPane.showMessageDialog(this, about, "About Memory Game", 1);
        }
        if (e.getActionCommand().equals(NEW_GAME)) {
            this.removeAll();
            this.addRandomCards();
            this.repaint();
        }
    }

    @ajcITD(targetType="memoryGame.classes.MemoryPanel", name="WrapperflipDown", modifiers=1)
    public void WrapperflipDown(MemoryCard memoryCard) {
        MUSDCoordinatorAspect.ajc$interMethod$memoryGame_aspects_MUSDCoordinatorAspect$memoryGame_classes_MemoryPanel$WrapperflipDown(this, memoryCard);
    }

    @ajcITD(targetType="memoryGame.classes.MemoryPanel", name="WrapperflipUp", modifiers=1)
    public void WrapperflipUp(MemoryCard memoryCard) {
        MUSDCoordinatorAspect.ajc$interMethod$memoryGame_aspects_MUSDCoordinatorAspect$memoryGame_classes_MemoryPanel$WrapperflipUp(this, memoryCard);
    }

    @ajcITD(targetType="memoryGame.classes.MemoryPanel", name="WrappersoundBeep", modifiers=1)
    public void WrappersoundBeep(MemoryPanel memoryPanel) {
        MUSDCoordinatorAspect.ajc$interMethod$memoryGame_aspects_MUSDCoordinatorAspect$memoryGame_classes_MemoryPanel$WrappersoundBeep(this, memoryPanel);
    }
}

