//  The file MUSDCoordinatorAspect.aj was automatically generated using S2A 0.2 beta.
//	Usage of the generated code is permitted for non-commercial research and evaluation purposes.
//	Removing or changing the above comment is prohibited by S2A 0.2 beta license agreement.
//	For information see http://www.wisdom.weizmann.ac.il/~maozs/s2a/

package memoryGame.aspects;

import memoryGame.classes.*;
import musd.runtime.lib.*;


public aspect MUSDCoordinatorAspect
{
	declare precedence: MUSDCoordinatorAspect, *;
	ICoordinatorStrategy strategy = new CoordinatorStrategyNaiveImpl();

	private boolean inAfter = false;
	private boolean fromAfter = false;

	public void MemoryPanel.WrapperflipDown(MemoryCard memoryCard)
	{
		memoryCard.flipDown();
	}

	public void MemoryPanel.WrapperflipUp(MemoryCard memoryCard)
	{
		memoryCard.flipUp();
	}

	public void MemoryCard.WrapperreDraw(MemoryCard memoryCard)
	{
		memoryCard.reDraw();
	}

	public void MemoryPanel.WrappersoundBeep(MemoryPanel memoryPanel)
	{
		memoryPanel.soundBeep();
	}

	pointcut MUSDMessage():
	execution(void MemoryPanel.soundBeep(..))
	|| call(void MemoryCard.flipUp(..))
	|| execution(void MemoryCard.reDraw(..))
	|| execution(void MemoryCard.mouseClicked(..))
	|| call(void MemoryCard.flipDown(..));


	after (): MUSDMessage()
	{
		if (!fromAfter) {
			fromAfter = true;
			afterImpl();
			fromAfter = false;
		}
	}


	void afterImpl() 
	{
		if (inAfter)
			inAfter = false;
		else inAfter = true;

		MUSDMethodSet monitoringEnabled = new MUSDMethodSet();
		MUSDMethodSet executingEnabled = new MUSDMethodSet();
		MUSDMethodSet coldViolation = new MUSDMethodSet();
		MUSDMethodSet hotViolation = new MUSDMethodSet();

		MUSDAspectReDraw.aspectOf().getCutState(monitoringEnabled, executingEnabled, coldViolation, hotViolation);
		MUSDAspectFlipUp.aspectOf().getCutState(monitoringEnabled, executingEnabled, coldViolation, hotViolation);
		MUSDAspectMatch.aspectOf().getCutState(monitoringEnabled, executingEnabled, coldViolation, hotViolation);

		MUSDMethod MUSDm = strategy.chooseMethod(monitoringEnabled, executingEnabled, coldViolation, hotViolation);

		if(MUSDm != null)
		{
			switch (MUSDm.messageID)
			{
				case MUSDMethods.MemoryPanel_MemoryCard_flipDown:
				 ((MemoryPanel)MUSDm.sourceInstance).WrapperflipDown(
					(MemoryCard)MUSDm.targetInstance);
				break;
				case MUSDMethods.MemoryPanel_MemoryCard_flipUp:
				 ((MemoryPanel)MUSDm.sourceInstance).WrapperflipUp(
					(MemoryCard)MUSDm.targetInstance);
				break;
				case MUSDMethods.MemoryCard_MemoryCard_reDraw:
				 ((MemoryCard)MUSDm.sourceInstance).WrapperreDraw(
					(MemoryCard)MUSDm.targetInstance);
				break;
				case MUSDMethods.MemoryPanel_MemoryPanel_soundBeep:
				 ((MemoryPanel)MUSDm.sourceInstance).WrappersoundBeep(
					(MemoryPanel)MUSDm.targetInstance);
				break;
			}
		}
		if (inAfter)
		{
			this.fromAfter = false;
			afterImpl();
		}
	}
}

