/**
 * MemoryPanel.java
 **/
package memoryGame.classes;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Random;

import javax.swing.JOptionPane;
import javax.swing.JPanel;

/**
 * MemoryPanel is the main GUI panel for the Memory game.
 **/
public class MemoryPanel extends JPanel implements ActionListener
{
	static final String ABOUT = "about";
	static final String NEW_GAME = "new game";
	
	private static final long serialVersionUID = 1L;
	private static MemoryPanel singleMemoryPanel = null;
	
	private ArrayList<MemoryCard> cards; 
	private Random rand;
	
   /**
   * Constructor. Create a Memory game with 16 cards.
   **/
  public MemoryPanel()
  {
  	singleMemoryPanel = this;
  	rand = new Random();	
  	// set the layout of this panel to be a grid layout
  	// 4x4 equal-sized blocks
  	setLayout( new GridLayout( 4, 4 ) );
    addRandomCards();
  }

  /**
   * Create and add card with specified description and color.
   **/
  private void addCard( String description, Color color )
  {
    // create a new card
    MemoryCard card = new MemoryCard( description, color );
    cards.add(card);
  }
  
  private void addRandomCards()
  {
	  cards = new ArrayList<MemoryCard>(16);
	  addCard( "Apple", Color.red );
	  addCard( "Orange", Color.red );
	  addCard( "Apple", Color.BLACK );
	  addCard( "Banana", Color.BLACK );
	  addCard( "Peach", Color.red );
	  addCard( "Banana", Color.BLACK );
	  addCard( "Orange", Color.red );
	  addCard( "Peach", Color.BLACK );
	  addCard( "Peach", Color.red );
	  addCard( "Orange", Color.BLACK );
	  addCard( "Banana", Color.red );
	  addCard( "Orange", Color.BLACK );
	  addCard( "Apple", Color.BLACK );
	  addCard( "Peach", Color.BLACK );
	  addCard( "Banana", Color.red );
	  addCard( "Apple", Color.red );
	  int index;
	  MemoryCard card;
	  for(int j=16;j>0;j--)
	  {
		  index = rand.nextInt(j);
		  card = cards.remove(index);
		  add(card);
	  }	
	  validate();
  }

  public static MemoryPanel getMemoryPanel()
  {
	  return singleMemoryPanel;
  } 

  public void soundBeep()
  {
	  java.awt.Toolkit.getDefaultToolkit ().beep();
  }

  public void actionPerformed(ActionEvent e)
  {
	  String about = "Memory Game\nConstructed using the S2A Compiler, July 2006\n" +
	  		"http://www.wisdom.weizmann.ac.il/~maozs/s2a/"; 

	  if(e.getActionCommand().equals(ABOUT))
	  {
		  JOptionPane.showMessageDialog(this,
				  about,"About Memory Game"
				  , JOptionPane.INFORMATION_MESSAGE);
	  }
	  if(e.getActionCommand().equals(NEW_GAME))
	  {
		  removeAll();
		  addRandomCards();
		  repaint();
	  }
  }
}
