/*
 * Decompiled with CFR 0.152.
 */
package newsticker;

import java.io.FileInputStream;
import java.util.Properties;
import javax.swing.SwingUtilities;
import newsticker.RSSDisplayFrame;
import newsticker.aspects.MUSDAspectFrameInit;
import newsticker.aspects.MUSDCoordinatorAspect;
import newsticker.rssutils.RSSList;
import newsticker.rssutils.RSSParser;
import org.aspectj.internal.lang.annotation.ajcITD;

public class NewsTickerApp {
    private static final String DEFAULT_RSS_ADDRESS = "http://newsrss.bbc.co.uk/rss/newsonline_world_edition/technology/rss.xml";
    private static final String PROPERTIES_FILE_NAME = "newsticker.properties";
    private static final String PROXY_HOST = "http.proxyHost";
    private static final String PROXY_PORT = "http.proxyPort";
    private static final String RSS_ADDRESS = "rssAddress";
    private static final String BROWSER_PATH = "browserPath";
    private static String initialRSSAddress = null;
    static String browserPath = "C:\\Program Files\\Internet Explorer\\IEXPLORE.EXE";

    public static void main(String[] args) {
        Properties properties = new Properties();
        String rssAddress = null;
        try {
            FileInputStream in = new FileInputStream(PROPERTIES_FILE_NAME);
            properties.load(in);
            String proxyHost = properties.getProperty(PROXY_HOST);
            String proxyPort = properties.getProperty(PROXY_PORT);
            String browser = properties.getProperty(BROWSER_PATH);
            rssAddress = properties.getProperty(RSS_ADDRESS);
            Properties systemProperties = System.getProperties();
            if (proxyHost != null && proxyHost != "") {
                systemProperties.put(PROXY_HOST, proxyHost);
            }
            if (proxyPort != null && proxyPort != "") {
                systemProperties.put(PROXY_PORT, proxyPort);
            }
            if (browser != null && browser != "") {
                browserPath = browser;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        initialRSSAddress = rssAddress == null || rssAddress == "" ? DEFAULT_RSS_ADDRESS : rssAddress;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NewsTickerApp.createAndShowGUI();
            }
        });
    }

    private static RSSList readRSS(String rssAddress) {
        RSSList itemList = RSSParser.getRSSItemList(rssAddress);
        return itemList;
    }

    private static void createAndShowGUI() {
        new NewsTickerApp();
    }

    NewsTickerApp() {
        RSSList list = NewsTickerApp.readRSS(initialRSSAddress);
        String string = initialRSSAddress;
        RSSList rSSList = list;
        try {
            try {
                new RSSDisplayFrame(rSSList, string);
            }
            finally {
                MUSDAspectFrameInit.aspectOf().ajc$after$newsticker_aspects_MUSDAspectFrameInit$7$ac86f63a(this);
            }
        }
        finally {
            MUSDCoordinatorAspect.aspectOf().ajc$after$newsticker_aspects_MUSDCoordinatorAspect$1$96aa1d4f();
        }
    }

    @ajcITD(targetType="newsticker.NewsTickerApp", name="Wrapperstart", modifiers=1)
    public void Wrapperstart(RSSDisplayFrame rSSDisplayFrame) {
        MUSDCoordinatorAspect.ajc$interMethod$newsticker_aspects_MUSDCoordinatorAspect$newsticker_NewsTickerApp$Wrapperstart(this, rSSDisplayFrame);
    }
}

