/*
 * Decompiled with CFR 0.152.
 */
package newsticker;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import newsticker.Blinker;
import newsticker.HorizontalRSSDisplay;
import newsticker.MUSDEnv;
import newsticker.PopupListener;
import newsticker.RSSDisplay;
import newsticker.RSSFeedTickerTimer;
import newsticker.ScrollTickerTimer;
import newsticker.VerticalRSSDisplay;
import newsticker.aspects.MUSDAspectBlinking;
import newsticker.aspects.MUSDAspectChangeScrollSpeed;
import newsticker.aspects.MUSDAspectFrameInit;
import newsticker.aspects.MUSDCoordinatorAspect;
import newsticker.rssutils.RSSList;
import newsticker.rssutils.RSSParser;
import org.aspectj.internal.lang.annotation.ajcITD;

public class RSSDisplayFrame
extends JFrame
implements ActionListener {
    private static final String MI_VERTICAL = "vertical";
    private static final String MI_HORIZONTAL = "horizontal";
    private static final String MI_SLOW = "slow";
    private static final String MI_FAST = "fast";
    private static final String MI_MEDIUM = "medium";
    private static final String MI_SETRSS = "setrss";
    private static final String MI_ABOUT = "about";
    private static final int HORIZONTAL_SPEED = 25;
    private static final int VERTICAL_SPEED = 35;
    private static final int HOR = 0;
    private static final int VER = 1;
    private static final long serialVersionUID = 1L;
    private RSSDisplay rssDisplay;
    private ScrollTickerTimer scrollingTimer;
    private String currentAddress;
    private RSSList currentList;
    private MouseListener popupListener;
    private int orientation;
    private Blinker blinker;

    public RSSDisplayFrame(RSSList list, String address) {
        super("NewsTicker: " + list.getTitle());
        RSSList rSSList = list;
        String string = address;
        try {
        }
        finally {
            MUSDAspectFrameInit.aspectOf().ajc$after$newsticker_aspects_MUSDAspectFrameInit$6$8c95dd38(this, rSSList, string);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void init(RSSList rSSList, String string) {
        RSSList rSSList2 = rSSList;
        String string2 = string;
        try {
            try {
                void address;
                void list;
                this.setSize(502, 50);
                this.currentList = list;
                this.currentAddress = address;
                this.setDefaultCloseOperation(3);
                this.setResizable(false);
                this.getContentPane().setForeground(Color.black);
                this.setVisible(true);
                this.initPopupMenu();
                this.changeOrientation(0);
                RSSFeedTickerTimer.setFrame(this);
            }
            finally {
                MUSDAspectFrameInit.aspectOf().ajc$after$newsticker_aspects_MUSDAspectFrameInit$1$4f586e0(this, rSSList2, string2);
            }
        }
        finally {
            MUSDCoordinatorAspect.aspectOf().ajc$after$newsticker_aspects_MUSDCoordinatorAspect$1$96aa1d4f();
        }
    }

    public void setRSSCaptions(RSSList list) {
        this.rssDisplay.setCaptions(list);
        this.setTitle(list.getTitle());
    }

    public void start() {
        ScrollTickerTimer scrollTickerTimer = this.scrollingTimer;
        try {
            try {
                scrollTickerTimer.start();
            }
            finally {
                MUSDAspectChangeScrollSpeed.aspectOf().ajc$after$newsticker_aspects_MUSDAspectChangeScrollSpeed$2$94021213(this, scrollTickerTimer);
            }
        }
        finally {
            MUSDCoordinatorAspect.aspectOf().ajc$after$newsticker_aspects_MUSDCoordinatorAspect$1$96aa1d4f();
        }
    }

    public void actionPerformed(ActionEvent e) {
        String com = e.getActionCommand();
        if (com.equals(MI_SLOW) || com.equals(MI_MEDIUM) || com.equals(MI_FAST)) {
            ScrollTickerTimer scrollTickerTimer = this.scrollingTimer;
            try {
                try {
                    scrollTickerTimer.stop();
                }
                finally {
                    MUSDAspectChangeScrollSpeed.aspectOf().ajc$after$newsticker_aspects_MUSDAspectChangeScrollSpeed$1$5626e3f9(this, scrollTickerTimer);
                }
            }
            finally {
                MUSDCoordinatorAspect.aspectOf().ajc$after$newsticker_aspects_MUSDCoordinatorAspect$1$96aa1d4f();
            }
            this.setScrollingSpeed(e.getActionCommand());
        }
        if (com.equals(MI_SETRSS)) {
            this.openSetRSSFeedDialog();
        }
        if (com.equals(MI_ABOUT)) {
            String about = "RSS News Ticker\nConstructed using the S2A Compiler, September 2006\nhttp://www.wisdom.weizmann.ac.il/~maozs/s2a/";
            JOptionPane.showMessageDialog(this, about, "About RSS News Ticker", 1);
        }
        if (com.equals(MI_HORIZONTAL)) {
            if (this.orientation == 0) {
                return;
            }
            this.changeOrientation(0);
            ScrollTickerTimer scrollTickerTimer = this.scrollingTimer;
            try {
                try {
                    scrollTickerTimer.start();
                }
                finally {
                    MUSDAspectChangeScrollSpeed.aspectOf().ajc$after$newsticker_aspects_MUSDAspectChangeScrollSpeed$2$94021213(this, scrollTickerTimer);
                }
            }
            finally {
                MUSDCoordinatorAspect.aspectOf().ajc$after$newsticker_aspects_MUSDCoordinatorAspect$1$96aa1d4f();
            }
        }
        if (com.equals(MI_VERTICAL)) {
            if (this.orientation == 1) {
                return;
            }
            this.changeOrientation(1);
            ScrollTickerTimer scrollTickerTimer = this.scrollingTimer;
            try {
                try {
                    scrollTickerTimer.start();
                }
                finally {
                    MUSDAspectChangeScrollSpeed.aspectOf().ajc$after$newsticker_aspects_MUSDAspectChangeScrollSpeed$2$94021213(this, scrollTickerTimer);
                }
            }
            finally {
                MUSDCoordinatorAspect.aspectOf().ajc$after$newsticker_aspects_MUSDCoordinatorAspect$1$96aa1d4f();
            }
        }
    }

    public void updateRSSCaptions() {
        this.updateRSSCaptions(this.currentAddress);
    }

    public void blinkingStarted() {
    }

    public void blinkingEnded() {
        this.blinker.setBackground(Color.green);
    }

    RSSDisplay getRSSDisplay() {
        return this.rssDisplay;
    }

    private JPopupMenu initPopupMenu() {
        JPopupMenu men = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Set RSS Feed...");
        menuItem.addActionListener(this);
        menuItem.setActionCommand(MI_SETRSS);
        men.add(menuItem);
        men.addSeparator();
        JMenu submenu = new JMenu("Scroll Direction");
        JMenuItem horizontal = new JMenuItem("Horizontal");
        JMenuItem vertical = new JMenuItem("Vertical");
        horizontal.addActionListener(this);
        vertical.addActionListener(this);
        horizontal.setActionCommand(MI_HORIZONTAL);
        vertical.setActionCommand(MI_VERTICAL);
        submenu.add(horizontal);
        submenu.add(vertical);
        men.add(submenu);
        JMenu submenuScroll = new JMenu("Scroll Speed");
        JMenuItem slow = new JMenuItem("Slow");
        JMenuItem medium = new JMenuItem("Medium");
        JMenuItem fast = new JMenuItem("Fast");
        slow.addActionListener(this);
        medium.addActionListener(this);
        fast.addActionListener(this);
        slow.setActionCommand(MI_SLOW);
        medium.setActionCommand(MI_MEDIUM);
        fast.setActionCommand(MI_FAST);
        submenuScroll.add(slow);
        submenuScroll.add(medium);
        submenuScroll.add(fast);
        men.add(submenuScroll);
        men.addSeparator();
        JMenuItem about = new JMenuItem("About...");
        about.addActionListener(this);
        about.setActionCommand(MI_ABOUT);
        men.add(about);
        this.popupListener = new PopupListener(men);
        this.addMouseListener(this.popupListener);
        return men;
    }

    private void openSetRSSFeedDialog() {
        String s = (String)JOptionPane.showInputDialog(this, "Site: ", "Set RSS Feed", -1, null, null, this.currentAddress);
        if (s != null && s.length() > 0) {
            this.updateRSSCaptions(s);
        }
    }

    private void updateRSSCaptions(String address) {
        this.currentAddress = address;
        RSSThread t = new RSSThread(address);
        t.start();
        Blinker blinker = this.blinker;
        try {
            try {
                blinker.startBlinking();
            }
            finally {
                MUSDAspectBlinking.aspectOf().ajc$after$newsticker_aspects_MUSDAspectBlinking$10$eafc1a99(this, blinker);
            }
        }
        finally {
            MUSDCoordinatorAspect.aspectOf().ajc$after$newsticker_aspects_MUSDCoordinatorAspect$1$96aa1d4f();
        }
    }

    private void setScrollingSpeed(String string) {
        String string2 = string;
        try {
            try {
            }
            finally {
                MUSDAspectChangeScrollSpeed.aspectOf().ajc$after$newsticker_aspects_MUSDAspectChangeScrollSpeed$3$8ea0e876(this, string2);
            }
        }
        finally {
            MUSDCoordinatorAspect.aspectOf().ajc$after$newsticker_aspects_MUSDCoordinatorAspect$1$96aa1d4f();
        }
    }

    private void changeOrientation(int or) {
        if (this.rssDisplay != null) {
            this.remove(this.rssDisplay);
        }
        if (or == 0) {
            this.rssDisplay = new HorizontalRSSDisplay();
            this.orientation = 0;
            this.scrollingTimer = new ScrollTickerTimer(25, this.rssDisplay);
            MUSDEnv.setDisplay(this.rssDisplay);
        } else {
            this.rssDisplay = new VerticalRSSDisplay();
            this.orientation = 1;
            this.scrollingTimer = new ScrollTickerTimer(35, this.rssDisplay);
            MUSDEnv.setDisplay(this.rssDisplay);
        }
        this.getContentPane().add((Component)this.rssDisplay, "Center");
        this.setRSSCaptions(this.currentList);
        MUSDEnv.setDisplay(this.rssDisplay);
        this.blinker = new Blinker();
        this.getContentPane().add((Component)this.blinker, "Last");
        this.blinker.setSize(this.rssDisplay.getWidth(), 1);
        this.setSize(this.rssDisplay.getWidth() + 2, this.rssDisplay.getHeight() + 42);
        this.setVisible(true);
        this.rssDisplay.addMouseListener(this.popupListener);
    }

    @ajcITD(targetType="newsticker.RSSDisplayFrame", name="Wrapperinit", modifiers=1)
    public void Wrapperinit(RSSDisplayFrame rSSDisplayFrame, RSSList rSSList, String string) {
        MUSDCoordinatorAspect.ajc$interMethod$newsticker_aspects_MUSDCoordinatorAspect$newsticker_RSSDisplayFrame$Wrapperinit(this, rSSDisplayFrame, rSSList, string);
    }

    @ajcITD(targetType="newsticker.RSSDisplayFrame", name="Wrappernew", modifiers=1)
    public void Wrappernew(RSSFeedTickerTimer rSSFeedTickerTimer, int n) {
        MUSDCoordinatorAspect.ajc$interMethod$newsticker_aspects_MUSDCoordinatorAspect$newsticker_RSSDisplayFrame$Wrappernew(this, rSSFeedTickerTimer, n);
    }

    @ajcITD(targetType="newsticker.RSSDisplayFrame", name="WrappersetInterval", modifiers=1)
    public void WrappersetInterval(ScrollTickerTimer scrollTickerTimer, int n) {
        MUSDCoordinatorAspect.ajc$interMethod$newsticker_aspects_MUSDCoordinatorAspect$newsticker_RSSDisplayFrame$WrappersetInterval(this, scrollTickerTimer, n);
    }

    @ajcITD(targetType="newsticker.RSSDisplayFrame", name="Wrapperstart", modifiers=1)
    public void Wrapperstart(RSSFeedTickerTimer rSSFeedTickerTimer) {
        MUSDCoordinatorAspect.ajc$interMethod$newsticker_aspects_MUSDCoordinatorAspect$newsticker_RSSDisplayFrame$Wrapperstart(this, rSSFeedTickerTimer);
    }

    @ajcITD(targetType="newsticker.RSSDisplayFrame", name="Wrapperstart", modifiers=1)
    public void Wrapperstart(ScrollTickerTimer scrollTickerTimer) {
        MUSDCoordinatorAspect.ajc$interMethod$newsticker_aspects_MUSDCoordinatorAspect$newsticker_RSSDisplayFrame$Wrapperstart(this, scrollTickerTimer);
    }

    private class RSSThread
    extends Thread {
        String address;

        public RSSThread(String address) {
            this.address = address;
        }

        public void run() {
            RSSList list = RSSParser.getRSSItemList(this.address);
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            RSSDisplayFrame.this.rssDisplay.setCaptions(list);
            RSSDisplayFrame.this.setTitle(list.getTitle());
        }
    }
}

