package newsticker.rssutils;



import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;

public class RSSParser 
{     
    static public RSSList getRSSItemList(String address)
    {
    	ArrayList<String> lineList = new ArrayList<String>();
    	RSSList resultList=null;
    	try
    	{
    		URL url = new URL(address);
    		URLConnection c = url.openConnection();
            c.connect();
            BufferedReader reader = new BufferedReader(new InputStreamReader(c.getInputStream()));
            String line;
            while ((line = reader.readLine()) != null) 
            	lineList.add(line);
            lineList.trimToSize();	
            resultList = parseFeed(lineList);
    	}
    	catch(MalformedURLException e)
    	{
    		System.err.println("Malformed URL Error: " + e.getMessage());
    	}
    	catch (IOException e)
    	{
    		System.err.println("IO Error: " + e.getMessage());
    	}
    	return resultList;
    }
    
    static RSSList parseFeed(ArrayList<String> lineList) throws IOException
    {     
    	RSSList outputList = new RSSList();
        boolean title = false;
        int begin, end;
        boolean isItem = false;
        boolean firstItem = false;
        Iterator<String> it = lineList.iterator();
        String line;
        String item = "";      
        while(it.hasNext())
        {
            line = it.next();
			while(true)
			{
				// Case: <item> tags.
                if(isItem || line.toLowerCase().contains("<item>")) 
                {
                    firstItem = true;
                    isItem = true;
                    int closeIndex = line.toLowerCase().indexOf("</item>");
                    if(closeIndex >= 0) 
                    {
                        item += line.substring(0, closeIndex);
                        line = line.substring(closeIndex + 1);
                        isItem = false;
                        outputList.add(RSSItem.parseItem(item.trim()));
                        item = "";
                    } 
                    else
                    {
					    isItem = true;
                        item += line;
                        break;
                    }
                } 
                else
                {
                	// Case: <title> tags
                    if (!firstItem && !title && line.toLowerCase().contains("<title>")) 
                    {
                        begin = line.toLowerCase().indexOf("<title>");
                        end = line.toLowerCase().indexOf("</title>");
                        if(begin < 0 || end < 0)
                            throw new IOException("Error parsing title of the RSS feed");
                        else 
                        {
                            String currentTitle = line.substring(begin + 7, end).replace("|", "#");
                            outputList.setTitle(currentTitle);
                            title = true;
                        }
                	}
            	}
            	break;
            }         
        }
        return outputList;
    }
}
