package phonebook;

import phonebook.model.PhoneBookModel;
import phonebook.view.extended.PhoneBookExtendedGUIView;

/**
 * Contains the main method for the Phone Book application
 * Application can be executed using the simple GUI or Extended GUI.
 * @author asafk
 */
public class PhoneBookApp {

	/**
	 * Main method for the phone book application.
	 * <p>
	 * Creates the model, controller, and view, and calls
	 * the controller's start method.
	 * 
	 * @param args not in use.
	 */
	public static void main(String[] args)
	{
				
		PhoneBookModel model = new PhoneBookModel();
		MSDEnv.setModel(model);
		PhoneBookController controller = new PhoneBookController(model);
	//	PhoneBookView view = new PhoneBookDefaultView(controller);
//		PhoneBookView view = PhoneBookSimpleGUIView.doView(controller);
		PhoneBookView view = PhoneBookExtendedGUIView.doView(controller);
		model.setView(view);
		MSDEnv.setView(view);
		MSDEnv.setController(controller);
		controller.start();
	}

}
