package phonebook.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;

import msd.runtime.lib.IPart;
/**
 * Part-of the Phone Book model.
 * Used to simulates complex data-base architecture.
 * @author asafk
 */
public class DBConnector implements IPart 
{
	private String searchResult = null;
	private Hashtable<String, String> phoneBook = null;
	private String name;
	private PhoneBookModel owner;
	
	private static final String RECORD_FILE = "phoneBook.txt";
	private static final String RECORD_SEPARATOR = "_|_";

	
	DBConnector(PhoneBookModel model)
	{
		owner = model;
		phoneBook = new Hashtable<String, String>();
		readRecords();
	}
	/**
	 * Adds a phone entry.
	 * 
	 * @param name
	 * @param number
	 */
	public void addAnEntry(String number) 
	{
		phoneBook.put(name, number);
	}

	/**
	 * Searchs the phone number and sets a private searchResult field.
	 * 
	 * @param name
	 */
	public void searchPhoneNumber(String name) {
		searchResult = (String) phoneBook.get(name);
	}

	/**
	 * Returns the search result.
	 */
	public String getSearchResult() {
		return searchResult;
	}
	
	/*
	 * Reads the phone entries from the file.
	 */
	private void readRecords() {
		File recordFile;

		try {
			recordFile = new File(RECORD_FILE);

			if (!recordFile.createNewFile()) {
				BufferedReader in = new BufferedReader(new FileReader(
						recordFile));

				String record = in.readLine();
				while (record != null && record.length() != 0) {
					int separatorIndex = record.indexOf(RECORD_SEPARATOR);
					if (separatorIndex != -1) {
						String name = record.substring(0, separatorIndex);
						String number = record.substring(separatorIndex
								+ RECORD_SEPARATOR.length());
						phoneBook.put(name, number);
					}
					record = in.readLine();
				}
				in.close();
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/*
	 * Writes the phone entries to the file.
	 */
	private void writeRecords() {
		try {
			FileOutputStream out = new FileOutputStream(RECORD_FILE);
			PrintStream p = new PrintStream(out);

			Enumeration e = phoneBook.keys();
			while (e.hasMoreElements()) {
				String name = (String) e.nextElement();
				String number = phoneBook.get(name);
				String newRecord = name + RECORD_SEPARATOR + number;
				p.println(newRecord);
			}
			p.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	public void saveAll()
	{
		writeRecords();
	}
	
	public void setName(String name) 
	{
		this.name = name;
	}
	
	public Object getOwner()
	{
		return owner;
	}
	
	public void standBy()
	{
		System.out.println("data base is standingBy");
		new NotifyThread(this,true).start();
	}
	
	public void closeConnection()
	{
		System.out.println("data base is closed");
		new NotifyThread(this,false).start();
	}
	
	public void dbStandsBy()
	{
		owner.modelController.dbStandsBy();
	}
	public void dbIsClosed() 
	{
		owner.modelController.dbIsClosed();
	}

}
