package phonebook.view.extended;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;

import javax.swing.JButton;

import msd.runtime.lib.IPart;
import phonebook.PhoneBookConstants;
import phonebook.view.simple.MessagePane;

/**
 * Part-of the {@link PhoneBookExtendedGUIView} class
 * Controlls its owner and its owner's parts operations 
 * @author asafk
 *
 */
public class ExtendedViewController implements ActionListener,IPart
{
	private static final int NO_INPUT=0;
	private static final int BUTTON_INPUT=1;
	private static final int PANE_INPUT=2;
	
	private PhoneBookExtendedGUIView owner;
	private MessagePane messagePane;
	private ExtendedInputPane extendedInputPane;
	private HashSet<Integer> legalStates;
	String lastInput;
	private int inputSource=NO_INPUT;
	
	public ExtendedViewController(PhoneBookExtendedGUIView view)
	{
		owner = view;
		messagePane = view.getMessagePane();
		extendedInputPane = view.getInputPane();
		legalStates = buildLegalStatesSet();
	}
	
	public void actionPerformed(ActionEvent e)
	{
		if(e.getSource() instanceof JButton)
		{
			inputSource=BUTTON_INPUT;
			lastInput = ((JButton)e.getSource()).getActionCommand();
		}
		if(e.getSource() instanceof ExtendedInputPane)
			inputSource=PANE_INPUT;
	}
	
	public void processInput()
	{
		if(inputSource==PANE_INPUT)
			extendedInputPane.doInput();
		if(inputSource==BUTTON_INPUT)
		{
			
		}
		inputSource= NO_INPUT;
	}
	
	public void stateHasChanged(int newState)
	{
		owner.changeView(newState);
	}

	public void userHasInput(String userInput)
	{
		
	}
	
	public void setLastInput(String input)
	{
		
	}
	
	public boolean isLegal(int state)
	{
		return legalStates.contains(state);
	}

	public Object getOwner() 
	{
		return owner;
	}

	//Called by the PhonebookView (super class of the owner) in cahngeView
	public void getUserInput(String question) 
	{
		messagePane.out(question);	
	}	
	
	public String getLastInput()
	{
		return lastInput;
	}
	
	private HashSet<Integer> buildLegalStatesSet()
	{
		HashSet<Integer> set = new HashSet<Integer>();
		set.add(PhoneBookConstants.STATE_ADD_NAME);
		set.add(PhoneBookConstants.STATE_ADD_NUMBER);
		set.add(PhoneBookConstants.STATE_ERROR);
		set.add(PhoneBookConstants.STATE_EXIT);
		set.add(PhoneBookConstants.STATE_IDLE);
		set.add(PhoneBookConstants.STATE_SEARCH);
		set.add(PhoneBookConstants.STATE_SEARCH_RESULT);
		return set;
	}
	
	public boolean validateInput()
	{
		return true;
	}

	public void handleInput() 
	{
		setLastInput(lastInput);		
	}

	
}
