package phonebook;

/**
 * Constants for the phone book application.
 * 
 * @author Shahar Maoz
 */
public class PhoneBookConstants {
	
	// The following are various states captured by the model
	public final static int STATE_ADD_NAME = 1;
	public final static int STATE_ADD_NUMBER = 2;
	public final static int STATE_SEARCH = 3;
	public final static int STATE_IDLE = 4;
	public final static int STATE_SEARCH_RESULT = 5;
	public final static int STATE_ERROR = 6;
	public final static int STATE_EXIT = 7;
	
	// The following are some commands that initiated by
	//   users selection
	public final static String COMMAND_START_STRING = "start";
	public final static String COMMAND_QUIT_STRING = "quit";
	public final static String COMMAND_ADD_STRING = "add";
	public final static String COMMAND_SEARCH_STRING = "search";

}
