package phonebook.view.extended;

import javax.swing.JTextField;
import javax.swing.text.BadLocationException;

import phonebook.PhoneBookConstants;

import msd.runtime.lib.IPart;

/**
 * Used as pane that allows the user to enter textual input.
 * Part-of the {@link PhoneBookExtendedGUIView} class
 * @author asafk
 */
public class ExtendedInputPane extends JTextField implements IPart
{
	private static final long serialVersionUID = 1L;
	
	private ExtendedViewController viewControll;
	private PhoneBookExtendedGUIView view;
	private boolean enab = false;
	
	public ExtendedInputPane(int i)
	{
		super(i);
		setEnabled(false);
	}
	
	public void setViewControll(PhoneBookExtendedGUIView view)
	{
		this.view = view;  
		viewControll = view.extendedViewControll;
	}
	
	public void setEnabled(boolean enabled)
	{
		setEditable(enabled);
		if(enabled && enab == false)
			addActionListener(view);
		else if(!enabled)
			removeActionListener(view);
		enab = enabled;
	}
	
	public Object getOwner()
	{
		return view;
	}

	public void doInput()
	{
		String answer = getText();	
		int len = getDocument().getLength();
		try {
			getDocument().remove(0, len);
		} catch (BadLocationException e) {
			e.printStackTrace();
		}
		viewControll.lastInput = answer;
	}
	
	public void checkForEnabled(int state)
	{
		if(state == PhoneBookConstants.STATE_ADD_NAME ||
				state == PhoneBookConstants.STATE_ADD_NUMBER
		|| state == PhoneBookConstants.STATE_SEARCH)
			setEnabled(true);
		else
			setEnabled(false);
	}
}

