package phonebook.view.simple;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JTextField;
import javax.swing.text.BadLocationException;

import phonebook.view.extended.ExtendedViewController;

import msd.runtime.lib.IPart;

/**
 * Part-of the {@link PhoneBookSimpleGUIView} class
 * Allows the user to enter textual inputs. 
 * @author asafk
 *
 */
public class InputPane extends JTextField implements ActionListener,IPart
{
	private static final long serialVersionUID = 1L;
	
	private ViewControll viewControll;
	
	public InputPane(int i)
	{
		super(i);
		addActionListener(this);
	}
	
	public void setViewControll(ViewControll controll)
	{
		viewControll = controll;
	}
	
	public void setEnabled(boolean enabled)
	{
		if(enabled)
			addActionListener(this);
		else
			removeActionListener(this);
	}
	
	public void actionPerformed(ActionEvent evt) 
	{
		String answer = getText();	
		int len = getDocument().getLength();
		try {
			getDocument().remove(0, len);
		} catch (BadLocationException e) {
			e.printStackTrace();
		}
		viewControll.userHasInput(answer);
	}

	public Object getOwner()
	{
		return viewControll.getOwner();
	}

	public void setExtendedViewControll(ExtendedViewController extendedViewControll)
	{
		// TODO Auto-generated method stub	
	}
}
