package phonebook.view.simple;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

import msd.runtime.lib.IOwner;

import phonebook.PhoneBookController;
import phonebook.PhoneBookView;

/**
 * Imlementation of a simple textual GUI for the Phone Book Applicatio.
 * Composed of three parts: {@link ViewControll},{@link InputPane}, and {@link MessagePane}
 * @author asafk
 */
public class PhoneBookSimpleGUIView extends PhoneBookView implements IOwner
{
	InputPane inputPane;
	MessagePane messagePane;
	ViewControll viewControll;
	
	private JPanel panel;


	public PhoneBookSimpleGUIView(PhoneBookController controller) 
	{
		super(controller);
		panel = new JPanel(new GridBagLayout());
		inputPane = new InputPane(20);
		messagePane = new MessagePane(5, 22,this);
		viewControll = new ViewControll(this);
		inputPane.setViewControll(viewControll);
		messagePane.setEditable(false);
		JScrollPane scrollPane = new JScrollPane(messagePane,
				JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,
				JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);

		//Add Components to this panel.
		JLabel inputLabel = new JLabel(" Input:");
		inputLabel.setLabelFor(inputPane);
		JLabel outputLabel = new JLabel(" Output message:");
		outputLabel.setLabelFor(messagePane);
		GridBagConstraints c = new GridBagConstraints();
		c.gridwidth = GridBagConstraints.REMAINDER;
		c.fill = GridBagConstraints.HORIZONTAL;
		panel.add(inputLabel, c);
		panel.add(inputPane, c);
		c.fill = GridBagConstraints.BOTH;
		c.weightx = 1.0;
		c.weighty = 1.0;
		panel.add(outputLabel, c);
		panel.add(scrollPane, c);
	}
	
	/**
	 * Create the GUI and show it.  For thread safety,
	 * this method should be invoked from the
	 * event-dispatching thread.
	 */
	private static void createAndShowGUI(PhoneBookSimpleGUIView view) 
	{
		//Create and set up the window.
		JFrame frame = new JFrame("Phone Book MVC");
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setResizable(false);

		//Create and set up the content pane.
		view.getPanel().setOpaque(true); //content panes must be opaque
		frame.setContentPane(view.getPanel());
		//Display the window.
		frame.pack();
		frame.setVisible(true);
	}
	

	public static PhoneBookSimpleGUIView doView(PhoneBookController c)
	{
		final PhoneBookSimpleGUIView v = new PhoneBookSimpleGUIView(c);
		//Schedule a job for the event-dispatching thread:
		//creating and showing this application's GUI.
		javax.swing.SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				createAndShowGUI(v);
			}
		});
		return v;
	}
	
	public void stateHasChanged(int newState) 
	{
		viewControll.stateHasChanged(newState);	
	}

	protected void getUserInput(String question) 
	{
		viewControll.getUserInput(question);
	}

	public JPanel getPanel() 
	{
		return panel;
	}

	public InputPane getInputPane() 
	{
		return inputPane;
	}

	public MessagePane getMessagePane() 
	{
		return messagePane;
	}

	public PhoneBookController getController() 
	{
		return phonebookcontroller;
	}
	
	public Object getPart(String name) 
	{		
		if(name.equals(inputPane.getClass().getName()))
			return inputPane;
		if(name.equals(messagePane.getClass().getName()))
			return messagePane;
		if(name.equals(viewControll.getClass().getName()))
			return viewControll;
		return null;
	}
}
