package phonebook.view.simple;

import java.util.HashSet;

import msd.runtime.lib.IPart;
import phonebook.PhoneBookConstants;

/**
 * Part-of the {@link PhoneBookSimpleGUIView} class
 * Controlls the operation of its owner and its owner's parts.
 * @author asafk
 *
 */
public class ViewControll implements IPart
{
	private PhoneBookSimpleGUIView owner;
	private MessagePane messagePane;
	private HashSet<Integer> legalStates;
	private static int i=0;
	
	public ViewControll(PhoneBookSimpleGUIView view)
	{
		owner = view;
		messagePane = view.getMessagePane();
		legalStates = buildLegalStatesSet();
	}

	public void stateHasChanged(int newState)
	{
		if(i++==0)
			owner.changeView(newState);
	}

	public void userHasInput(String userInput)
	{

	}

	public boolean isLegal(int state)
	{
		return legalStates.contains(state);
	}

	public Object getOwner() 
	{
		return owner;
	}

	//Called by the PhonebookView (super class of the owner) in cahngeView
	public void getUserInput(String question) 
	{
		messagePane.out(question);	
	}	
	
	private HashSet<Integer> buildLegalStatesSet()
	{
		HashSet<Integer> set = new HashSet<Integer>();
		set.add(PhoneBookConstants.STATE_ADD_NAME);
		set.add(PhoneBookConstants.STATE_ADD_NUMBER);
		set.add(PhoneBookConstants.STATE_ERROR);
		set.add(PhoneBookConstants.STATE_EXIT);
		set.add(PhoneBookConstants.STATE_IDLE);
		set.add(PhoneBookConstants.STATE_SEARCH);
		set.add(PhoneBookConstants.STATE_SEARCH_RESULT);
		return set;
	}
	
}
