/*
 * Decompiled with CFR 0.152.
 */
package phonebook.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import msd.runtime.lib.IPart;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import phonebook.aspects.MSDAspectMVCAbstract;
import phonebook.aspects.MSDCoordinatorAspect;
import phonebook.model.ModelControll;
import phonebook.model.NotifyThread;
import phonebook.model.PhoneBookModel;

public class DBConnector
implements IPart {
    private String searchResult = null;
    private Hashtable<String, String> phoneBook = null;
    private String name;
    private PhoneBookModel owner;
    private static final String RECORD_FILE = "phoneBook.txt";
    private static final String RECORD_SEPARATOR = "_|_";
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    DBConnector(PhoneBookModel model) {
        this.owner = model;
        this.phoneBook = new Hashtable();
        this.readRecords();
    }

    public void addAnEntry(String number) {
        this.phoneBook.put(this.name, number);
    }

    public void searchPhoneNumber(String name) {
        this.searchResult = this.phoneBook.get(name);
    }

    public String getSearchResult() {
        return this.searchResult;
    }

    private void readRecords() {
        try {
            File recordFile = new File(RECORD_FILE);
            if (!recordFile.createNewFile()) {
                BufferedReader in = new BufferedReader(new FileReader(recordFile));
                String record = in.readLine();
                while (record != null && record.length() != 0) {
                    int separatorIndex = record.indexOf(RECORD_SEPARATOR);
                    if (separatorIndex != -1) {
                        String name = record.substring(0, separatorIndex);
                        String number = record.substring(separatorIndex + RECORD_SEPARATOR.length());
                        this.phoneBook.put(name, number);
                    }
                    record = in.readLine();
                }
                in.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writeRecords() {
        try {
            FileOutputStream out = new FileOutputStream(RECORD_FILE);
            PrintStream p = new PrintStream(out);
            Enumeration<String> e = this.phoneBook.keys();
            while (e.hasMoreElements()) {
                String name = e.nextElement();
                String number = this.phoneBook.get(name);
                String newRecord = String.valueOf(name) + RECORD_SEPARATOR + number;
                p.println(newRecord);
            }
            p.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveAll() {
        this.writeRecords();
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getOwner() {
        return this.owner;
    }

    public void standBy() {
        System.out.println("data base is standingBy");
        new NotifyThread(this, true).start();
    }

    public void closeConnection() {
        System.out.println("data base is closed");
        new NotifyThread(this, false).start();
    }

    public void dbStandsBy() {
        ModelControll modelControll = this.owner.modelController;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_0, this, modelControll);
        try {
            try {
                modelControll.dbStandsBy();
            }
            finally {
                MSDAspectMVCAbstract.aspectOf().ajc$after$phonebook_aspects_MSDAspectMVCAbstract$9$6a763f1c(this, modelControll);
            }
        }
        finally {
            MSDCoordinatorAspect.aspectOf().ajc$after$phonebook_aspects_MSDCoordinatorAspect$1$9bb3fd8a(joinPoint);
        }
    }

    public void dbIsClosed() {
        ModelControll modelControll = this.owner.modelController;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_1, this, modelControll);
        try {
            try {
                modelControll.dbIsClosed();
            }
            finally {
                MSDAspectMVCAbstract.aspectOf().ajc$after$phonebook_aspects_MSDAspectMVCAbstract$7$4b1c113e(this, modelControll);
            }
        }
        finally {
            MSDCoordinatorAspect.aspectOf().ajc$after$phonebook_aspects_MSDCoordinatorAspect$1$9bb3fd8a(joinPoint);
        }
    }

    static {
        Factory factory = new Factory("DBConnector.java", Class.forName("phonebook.model.DBConnector"));
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "dbStandsBy", "phonebook.model.ModelControll", "", "", "", "void"), 143);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "dbIsClosed", "phonebook.model.ModelControll", "", "", "", "void"), 147);
    }
}

