package mvc.interfaces;


/**
 * Classes that implementes this interface should play
 * the role of a Controller in the Model-View-Controller design pattern.
 * The Controller Usually processes and responds to events
 * typically user actions and may invoke changes on the model.
 */
public interface IController
{
	/**
	 * Called by {@link IView} to notify about input.
	 * 
	 * @param userInput - The user's input
	 */
	public void userHasInput(String userInput);
}
