package phonebook;

import java.io.BufferedReader;
import java.io.InputStreamReader;

/**
 * A simple command line interface is implemented.
 */
public class PhoneBookDefaultView extends PhoneBookView
{

	public PhoneBookDefaultView(PhoneBookController controller)
	{
		super(controller);
	}
	/*
	 * Displays question and gets user input.
	 * @param question
	 */
	protected void getUserInput(String question) 
	{
		BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
		out(question);
		try
		{
			answer = in.readLine().trim();
		} 
		catch (Exception e) 
		{
			e.printStackTrace();
		}
	}

	/**
	 * Called by the model when the state has been changed
	 * @param newState
	 */
	public void stateHasChanged(int newState) 
	{
		changeView(newState);
		sendUserInput();
	}

	protected void sendUserInput() 
	{
		phonebookcontroller.userHasInput(answer);
	}
}
