package phonebook.model;

import msd.runtime.lib.IOwner;
import mvc.interfaces.IModel;
import phonebook.PhoneBookView;

/*
 * Created on September 2, 2006
 */

/**
 * Model for the phone book application. The phone book entries are
 * persisted to a file.
 * Composed of two parts {@link ModelControll} and {@link DBConnector}
 * Mainly contains proxy methos methods for its parts 
 * @author Shahar Maoz & Asaf Kleinbort
 */

public class PhoneBookModel implements IModel,IOwner
{	
	ModelControll modelController;
	DBConnector dbConnector;
	
	/**
	 * Constructor.
	 */
	public PhoneBookModel(){
		dbConnector = new DBConnector(this);
		modelController = new ModelControll(this);
	}
	
	/**
	 * Sets the model's state.
	 */
	public void setState(int aState) 
	{
		modelController.setState(aState);
	}

	/**
	 * Adds a phone entry.
	 */
	public void addAnEntry(String number){
		dbConnector.addAnEntry(number);
	}

	/**
	 * Searchs the phone number and sets a private searchResult field.
	 */
	public void searchPhoneNumber(String name){
		dbConnector.searchPhoneNumber(name);
	}

	/**
	 * Returns the search result.
	 */
	public String getSearchResult(){
		return dbConnector.getSearchResult();
	}

	/**
	 * Returns the current state.
	 */
	public int getState(){
		return modelController.getState();
	}


	
	public void setView(PhoneBookView view)	{
		modelController.setView(view);
	}

	/**
	 * Saves all the phone entries.
	 */
	public void saveAll(){
		dbConnector.saveAll();
	}
	
	public void setName(String name){
		dbConnector.setName(name);
	}
	
	public DBConnector getDBConnector()
	{
		return dbConnector;
	}

	public void start() 
	{
		modelController.start();
			
	}

	public Object getPart(String name) 
	{
		if(name.equals(modelController.getClass().getName()))
			return modelController;
		if(name.equals(dbConnector.getClass().getName()))
			return dbConnector;
		return null;
	}
}
