package phonebook.view.extended;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;

import phonebook.PhoneBookConstants;
import phonebook.PhoneBookController;
import phonebook.view.simple.MessagePane;

public class ExtendedViewController implements ActionListener
{
	private PhoneBookExtendedGUIView owner;
	private MessagePane messagePane;
	private PhoneBookController phonebookcontroller;
	private HashSet<Integer> legalStates;
	
	public ExtendedViewController(PhoneBookExtendedGUIView view)
	{
		owner = view;
		messagePane = view.getMessagePane();
		phonebookcontroller = view.getController();
		legalStates = buildLegalStatesSet();
	}
	
	public void actionPerformed(ActionEvent e)
	{
		
	}
	
	public boolean validateInput()
	{
		return false;
	}
	
	public void stateHasChanged(int newState)
	{
		owner.changeView(newState);
	}

	public void userHasInput(String userInput)
	{
		//phonebookcontroller.userHasInput(userInput);//called by the Coordinator
	}
	
	public void userHasInput2(String userInput)
	{
		phonebookcontroller.userHasInput(userInput);
//		messagePane.setCaretPosition(messagePane.getDocument().getLength());
	}

	public boolean isLegal(int state)
	{
		return legalStates.contains(state);
	}

	public Object getOwner() 
	{
		return owner;
	}

	//Called by the PhonebookView (super class of the owner) in cahngeView
	public void getUserInput(String question) 
	{
		messagePane.out(question);	
	}	
	
	private HashSet<Integer> buildLegalStatesSet()
	{
		HashSet<Integer> set = new HashSet<Integer>();
		set.add(PhoneBookConstants.STATE_ADD_NAME);
		set.add(PhoneBookConstants.STATE_ADD_NUMBER);
		set.add(PhoneBookConstants.STATE_ERROR);
		set.add(PhoneBookConstants.STATE_EXIT);
		set.add(PhoneBookConstants.STATE_IDLE);
		set.add(PhoneBookConstants.STATE_SEARCH);
		set.add(PhoneBookConstants.STATE_SEARCH_RESULT);
		return set;
	}
	
}
