/*
 * Decompiled with CFR 0.152.
 */
package phonebook;

import mvc.interfaces.IView;
import phonebook.PhoneBookController;

public abstract class PhoneBookView
implements IView {
    private static final String ADD_NAME_Q = "Please enter the exact person name";
    private static final String ADD_NUMBER_Q = "Please enter the phone number";
    private static final String SEARCH_Q = "Please enter the exact person name.";
    private static final String IDLE_Q = "Please type your choice of action:\n\"add\" to add a phone entry \n\"search\" to search for a phone number \n\"quit\" to exit.";
    private static final String SEARCH_RESULT = "The phone number is: ";
    private static final String SEARCH_RESULT_Q = "Enter \"start\" to do more with the application.\nEnter \"quit\" to exit.";
    private static final String SEARCH_NOT_FOUND_Q = "Person's phone number not found.\nEnter \"start\" to do more with the application.\nEnter \"quit\" to exit.";
    private static final String ERROR_Q = "You've entered an invalid choice.\nEnter \"start\" to do more with the application.\nEnter \"quit\" to exit.";
    private static final String EXIT = "Thanks for using the application.";
    protected PhoneBookController phonebookcontroller;
    protected String answer;

    public abstract void stateHasChanged(int var1);

    protected abstract void getUserInput(String var1);

    public PhoneBookView(PhoneBookController controller) {
        this.phonebookcontroller = controller;
    }

    public void changeView(int newState) {
        if (newState == 4) {
            this.getUserInput(IDLE_Q);
        } else if (newState == 1) {
            this.getUserInput(ADD_NAME_Q);
        } else if (newState == 2) {
            this.getUserInput(ADD_NUMBER_Q);
        } else if (newState == 3) {
            this.getUserInput(SEARCH_Q);
        } else if (newState == 5) {
            String result = this.phonebookcontroller.getModel().getSearchResult();
            if (result == null || result.length() == 0) {
                this.getUserInput(SEARCH_NOT_FOUND_Q);
            } else {
                this.getUserInput(SEARCH_RESULT + result + "\n" + SEARCH_RESULT_Q);
            }
        } else if (newState == 6) {
            this.getUserInput(ERROR_Q);
        } else if (newState == 7) {
            this.out(EXIT);
        }
    }

    protected void out(String s) {
        System.out.println(s);
    }
}

