/*
 * Decompiled with CFR 0.152.
 */
package phonebook;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import mvc.interfaces.IModel;
import mvc.interfaces.IView;
import org.aspectj.internal.lang.annotation.ajcITD;
import phonebook.aspects.MUSDCoordinatorAspect;

public class PhoneBookModel
implements IModel {
    private int state = 4;
    private String searchResult = null;
    private Hashtable<String, String> phoneBook = new Hashtable();
    private static final String RECORD_FILE = "phoneBook.txt";
    private static final String RECORD_SEPARATOR = "_|_";
    private String name;

    public void setState(int aState) {
        this.state = aState;
    }

    public void addAnEntry(String number) {
        this.phoneBook.put(this.name, number);
    }

    public void searchPhoneNumber(String name) {
        this.searchResult = this.phoneBook.get(name);
    }

    public String getSearchResult() {
        return this.searchResult;
    }

    public int getState() {
        return this.state;
    }

    public PhoneBookModel() {
        this.readRecords();
    }

    public void saveAll() {
        this.writeRecords();
    }

    private void readRecords() {
        try {
            File recordFile = new File(RECORD_FILE);
            if (!recordFile.createNewFile()) {
                BufferedReader in = new BufferedReader(new FileReader(recordFile));
                String record = in.readLine();
                while (record != null && record.length() != 0) {
                    int separatorIndex = record.indexOf(RECORD_SEPARATOR);
                    if (separatorIndex != -1) {
                        String name = record.substring(0, separatorIndex);
                        String number = record.substring(separatorIndex + RECORD_SEPARATOR.length());
                        this.phoneBook.put(name, number);
                    }
                    record = in.readLine();
                }
                in.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writeRecords() {
        try {
            FileOutputStream out = new FileOutputStream(RECORD_FILE);
            PrintStream p = new PrintStream(out);
            Enumeration<String> e = this.phoneBook.keys();
            while (e.hasMoreElements()) {
                String name = e.nextElement();
                String number = this.phoneBook.get(name);
                String newRecord = String.valueOf(name) + RECORD_SEPARATOR + number;
                p.println(newRecord);
            }
            p.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    @ajcITD(targetType="mvc.interfaces.IModel", name="WrapperstateHasChanged", modifiers=1)
    public void WrapperstateHasChanged(IView iView, Integer n) {
        MUSDCoordinatorAspect.ajc$interMethod$phonebook_aspects_MUSDCoordinatorAspect$mvc_interfaces_IModel$WrapperstateHasChanged(this, iView, n);
    }
}

