/*
 * Decompiled with CFR 0.152.
 */
package phonebook;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import mvc.interfaces.IView;
import org.aspectj.runtime.internal.Conversions;
import phonebook.PhoneBookController;
import phonebook.aspects.MUSDAspectSetState;
import phonebook.aspects.MUSDAspectUserErrorInput;
import phonebook.aspects.MUSDAspectUserInput;
import phonebook.aspects.MUSDCoordinatorAspect;

public class PhoneBookView
implements IView {
    protected PhoneBookController phonebookcontroller;
    private static final String ADD_NAME_Q = "Please enter the exact person name";
    private static final String ADD_NUMBER_Q = "Please enter the phone number";
    private static final String SEARCH_Q = "Please enter the exact person name.";
    private static final String IDLE_Q = "Please enter your choice of action:\n\"add\" to add a phone entry \n\"search\" to search for a phone number \n\"quit\" to exit.";
    private static final String SEARCH_RESULT = "The phone number is: ";
    private static final String SEARCH_RESULT_Q = "Enter \"start\" to do more with the application.\nEnter \"quit\" to exit.";
    private static final String SEARCH_NOT_FOUND_Q = "Person's phone number not found.\nEnter \"start\" to do more with the application.\nEnter \"quit\" to exit.";
    private static final String ERROR_Q = "You've entered an invalid choice.\nEnter \"start\" to do more with the application.\nEnter \"quit\" to exit.";
    private static final String EXIT = "Thanks for using the application.";
    protected String answer;

    public PhoneBookView(PhoneBookController controller) {
        this.phonebookcontroller = controller;
    }

    public void stateHasChanged(int newState) {
        this.changeView(newState);
        this.sendUserInput();
    }

    /*
     * WARNING - void declaration
     */
    public void changeView(int n) {
        int n2 = n;
        try {
            try {
                void newState;
                if (newState == 4) {
                    this.getUserInput(IDLE_Q);
                } else if (newState == true) {
                    this.getUserInput(ADD_NAME_Q);
                } else if (newState == 2) {
                    this.getUserInput(ADD_NUMBER_Q);
                } else if (newState == 3) {
                    this.getUserInput(SEARCH_Q);
                } else if (newState == 5) {
                    String result = this.phonebookcontroller.getModel().getSearchResult();
                    if (result == null || result.length() == 0) {
                        this.getUserInput(SEARCH_NOT_FOUND_Q);
                    } else {
                        this.getUserInput(SEARCH_RESULT + result + "\n" + SEARCH_RESULT_Q);
                    }
                } else if (newState == 6) {
                    this.getUserInput(ERROR_Q);
                } else if (newState == 7) {
                    this.out(EXIT);
                }
            }
            finally {
                MUSDAspectSetState.aspectOf().ajc$after$phonebook_aspects_MUSDAspectSetState$2$5adbef4(this, (Integer)Conversions.intObject(n2));
            }
        }
        finally {
            MUSDCoordinatorAspect.aspectOf().ajc$after$phonebook_aspects_MUSDCoordinatorAspect$1$96aa1d4f();
        }
    }

    protected void getUserInput(String question) {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        this.out(question);
        try {
            this.answer = in.readLine().trim();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendUserInput() {
        String string = this.answer;
        PhoneBookController phoneBookController = this.phonebookcontroller;
        try {
            try {
                try {
                    phoneBookController.userHasInput(string);
                }
                finally {
                    MUSDAspectUserInput.aspectOf().ajc$after$phonebook_aspects_MUSDAspectUserInput$4$ec78b4b7(this, phoneBookController, string);
                }
            }
            finally {
                MUSDAspectUserErrorInput.aspectOf().ajc$after$phonebook_aspects_MUSDAspectUserErrorInput$1$ec78b4b7(this, phoneBookController, string);
            }
        }
        finally {
            MUSDCoordinatorAspect.aspectOf().ajc$after$phonebook_aspects_MUSDCoordinatorAspect$1$96aa1d4f();
        }
    }

    protected void out(String s) {
        System.out.println(s);
    }
}

