package phonebook;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;

public class PhoneBookGUIView extends PhoneBookView implements ActionListener
{
	protected JTextField textField;
	protected JTextArea textArea;
	private JPanel panel;


	public PhoneBookGUIView(PhoneBookController controller) 
	{
		super(controller);
		panel = new JPanel(new GridBagLayout());
		textField = new JTextField(20);
		textArea = new JTextArea(5, 22);
		textField.addActionListener(this);
		textArea.setEditable(false);
		JScrollPane scrollPane = new JScrollPane(textArea,
				JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,
				JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);

		//Add Components to this panel.
		JLabel inputLabel = new JLabel(" Input:");
		inputLabel.setLabelFor(textField);
		JLabel outputLabel = new JLabel(" Output message:");
		outputLabel.setLabelFor(textArea);
		GridBagConstraints c = new GridBagConstraints();
		c.gridwidth = GridBagConstraints.REMAINDER;
		c.fill = GridBagConstraints.HORIZONTAL;
		panel.add(inputLabel, c);
		panel.add(textField, c);
		c.fill = GridBagConstraints.BOTH;
		c.weightx = 1.0;
		c.weighty = 1.0;
		panel.add(outputLabel, c);
		panel.add(scrollPane, c);
	}

	public void stateHasChanged(int newState) 
	{
		changeView(newState);
	}

	public void actionPerformed(ActionEvent evt) 
	{
		answer = textField.getText();	
		int len = textField.getDocument().getLength();
		try {
			textField.getDocument().remove(0, len);
		} catch (BadLocationException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		phonebookcontroller.userHasInput(answer);
		textArea.setCaretPosition(textArea.getDocument().getLength());
	}

	/**
	 * Create the GUI and show it.  For thread safety,
	 * this method should be invoked from the
	 * event-dispatching thread.
	 */
	private static void createAndShowGUI(PhoneBookGUIView view) 
	{
		//Create and set up the window.
		JFrame frame = new JFrame("Phone Book MVC");
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setResizable(false);

		//Create and set up the content pane.
		view.getPanel().setOpaque(true); //content panes must be opaque
		frame.setContentPane(view.getPanel());
		//Display the window.
		frame.pack();
		frame.setVisible(true);
	}

	public static PhoneBookGUIView doView(PhoneBookController c)
	{
		final PhoneBookGUIView v = new PhoneBookGUIView(c);
		//Schedule a job for the event-dispatching thread:
		//creating and showing this application's GUI.
		javax.swing.SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				createAndShowGUI(v);
			}
		});
		return v;
	}

	protected void out(String s)
	{
		int len = textArea.getDocument().getLength();
		try
		{
			textArea.getDocument().remove(0, len);
		}
		catch (Exception e)	{}
		textArea.append(s);
	}

	protected void getUserInput(String question) 
	{
		out(question);
	}

	public JPanel getPanel() 
	{
		return panel;
	}
}
