package phonebook;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;

import mvc.interfaces.IModel;

/*
 * Created on September 2, 2006
 */

/**
 * Model for the phone book application. The phone book entries are
 * persisted to a file.
 * 
 * @author Shahar Maoz
 */

public class PhoneBookModel implements IModel 
{

	//private PhoneBookView phonebookview;

	// Private fields used to track various model data
	private int state = PhoneBookConstants.STATE_IDLE;

	private String searchResult = null;

	private Hashtable<String, String> phoneBook = null;

	// For persisting the phone book entries into a file
	private static final String RECORD_FILE = "phoneBook.txt";

	private static final String RECORD_SEPARATOR = "_|_";
	
	private String name;

	/**
	 * Sets the model's state.
	 * 
	 * @param aState
	 */
	public void setState(int aState) {
		state = aState;
		//phonebookview.stateHasChanged(state);//called by musd
	}

	/**
	 * Adds a phone entry.
	 * 
	 * @param name
	 * @param number
	 */
	public void addAnEntry(String number) {
		phoneBook.put(name, number);
	}

	/**
	 * Searchs the phone number and sets a private searchResult field.
	 * 
	 * @param name
	 */
	public void searchPhoneNumber(String name) {
		searchResult = (String) phoneBook.get(name);
	}

	/**
	 * Returns the search result.
	 */
	public String getSearchResult() {
		return searchResult;
	}

	/**
	 * Returns the current state.
	 * 
	 * @return the current state.
	 */
	public int getState() {
		return state;
	}

	/**
	 * Constructor.
	 * 
	 * @param view
	 */
	public PhoneBookModel() {
		//phonebookview = view;
		phoneBook = new Hashtable<String, String>();
		readRecords();
	}

	/**
	 * Saves all the phone entries.
	 */
	public void saveAll() {
		writeRecords();
	}

	/*
	 * Reads the phone entries from the file.
	 */
	private void readRecords() {
		File recordFile;

		try {
			recordFile = new File(RECORD_FILE);

			if (!recordFile.createNewFile()) {
				BufferedReader in = new BufferedReader(new FileReader(
						recordFile));

				String record = in.readLine();
				while (record != null && record.length() != 0) {
					int separatorIndex = record.indexOf(RECORD_SEPARATOR);
					if (separatorIndex != -1) {
						String name = record.substring(0, separatorIndex);
						String number = record.substring(separatorIndex
								+ RECORD_SEPARATOR.length());
						phoneBook.put(name, number);
					}
					record = in.readLine();
				}
				in.close();
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/*
	 * Writes the phone entries to the file.
	 */
	private void writeRecords() {
		try {
			FileOutputStream out = new FileOutputStream(RECORD_FILE);
			PrintStream p = new PrintStream(out);

			Enumeration e = phoneBook.keys();
			while (e.hasMoreElements()) {
				String name = (String) e.nextElement();
				String number = phoneBook.get(name);
				String newRecord = name + RECORD_SEPARATOR + number;
				p.println(newRecord);
			}
			p.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	public void setName(String name) {
		this.name = name;
	}
}
