package phonebook;

import java.io.BufferedReader;
import java.io.InputStreamReader;

import mvc.interfaces.IView;

/*
 * Created on September 2, 2006
 */

/**
 * View for the phone book application.
 * A simple command line interface is implemented.
 * 
 * @author Shahar Maoz
 */

public class PhoneBookView implements IView 
{

	protected PhoneBookController phonebookcontroller;

	//private PhoneBookModel phonebookmodel;

	//Strings used by the command line interface
	private final static String ADD_NAME_Q = "Please enter the exact person name";

	private final static String ADD_NUMBER_Q = "Please enter the phone number";

	private final static String SEARCH_Q = "Please enter the exact person name.";

	private final static String IDLE_Q = "Please enter your choice of action:\n\""
			+ PhoneBookConstants.COMMAND_ADD_STRING
			+ "\" to add a phone entry \n\""
			+ PhoneBookConstants.COMMAND_SEARCH_STRING
			+ "\" to search for a phone number \n\""
			+ PhoneBookConstants.COMMAND_QUIT_STRING + "\" to exit.";

	private final static String SEARCH_RESULT = "The phone number is: ";

	private final static String SEARCH_RESULT_Q = "Enter \""
			+ PhoneBookConstants.COMMAND_START_STRING
			+ "\" to do more with the application.\nEnter \""
			+ PhoneBookConstants.COMMAND_QUIT_STRING + "\" to exit.";

	private final static String SEARCH_NOT_FOUND_Q = "Person's phone number not found.\nEnter \""
			+ PhoneBookConstants.COMMAND_START_STRING
			+ "\" to do more with the application.\nEnter \""
			+ PhoneBookConstants.COMMAND_QUIT_STRING + "\" to exit.";

	private final static String ERROR_Q = "You've entered an invalid choice.\nEnter \""
			+ PhoneBookConstants.COMMAND_START_STRING
			+ "\" to do more with the application.\nEnter \""
			+ PhoneBookConstants.COMMAND_QUIT_STRING + "\" to exit.";

	private final static String EXIT = "Thanks for using the application.";

	/**
	 * Constructor.
	 * @param controller
	 */
	public PhoneBookView(PhoneBookController controller) {
		phonebookcontroller = controller;
	}

	/**
     * Called by the model when the state has been changed
     * @param newState
     */
    public void stateHasChanged(int newState) {
            //phonebookmodel = model;
            changeView(newState); //THIS IS NOT COMMENTED
            sendUserInput();  // THIS IS NEW
    }

	/*
	 * Changes the view based on the new state.
	 * @param newState
	 */
	public void changeView(int newState) {
		if (newState == PhoneBookConstants.STATE_IDLE) {
			getUserInput(IDLE_Q);
		} else if (newState == PhoneBookConstants.STATE_ADD_NAME) {
			getUserInput(ADD_NAME_Q);
		} else if (newState == PhoneBookConstants.STATE_ADD_NUMBER) {
			getUserInput(ADD_NUMBER_Q);
		} else if (newState == PhoneBookConstants.STATE_SEARCH) {
			getUserInput(SEARCH_Q);
		} else if (newState == PhoneBookConstants.STATE_SEARCH_RESULT) {
			String result = phonebookcontroller.getModel().getSearchResult();
			if (result == null || result.length() == 0) {
				getUserInput(SEARCH_NOT_FOUND_Q);
			} else {
				getUserInput(SEARCH_RESULT + result + "\n" + SEARCH_RESULT_Q);
			}
		} else if (newState == PhoneBookConstants.STATE_ERROR) {
			getUserInput(ERROR_Q);
		} else if (newState == PhoneBookConstants.STATE_EXIT) {
			out(EXIT);
		}
	}

    /*
     * Displays question and gets user input.
     * @param question
     */
    protected void getUserInput(String question) {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            out(question);
            try {
                    answer = in.readLine().trim();
                    //System.out.println("answer set");
                    //phonebookcontroller.userHasInput(answer); THIS IS NOW COMMENTED
            } catch (Exception e) {
                    e.printStackTrace();
            }
    }

    protected String answer; //THIS IS NEW

    private void sendUserInput() { //THIS IS NEW
            phonebookcontroller.userHasInput(answer);
    }
    
    protected void out(String s)
    {
    	System.out.println(s);
    }
}
