% simulation for table 4 (canonical correlation analysis)

%p=2; q=5; N = 41; 	% N = number of samples
%p=3; q=7; N = 51; 	% N = number of samples
p=5; q=10; N = 51; 	% N = number of samples

n = N-1; 
m = p + q ; % m = overall dimension

alpha1 = 0.01; % false alarm / type I error rate
alpha5 = 0.05; 

rho_arr = [0.0 0.5 0.6 0.7]; 
n_rho = length(rho_arr); 

iter = 200000; 
L1 = zeros(n_rho,iter); 

for counter=1:iter

    if mod(counter,1000)==0
        fprintf('counter %d/%d\n',counter,iter); 
    end
    for j=1:n_rho
        
        rho = rho_arr(j); 
        
        % generate data
        Sigma = eye(m); 
        Sigma(1,p+1) = rho; Sigma(p+1,1) = rho; 
        
        R = chol(Sigma);
        
        X = randn(N,m) * R; 
        mu_X = mean(X); 
        Xc = X - repmat(mu_X,N,1); %mean center the data
        A = Xc' * Xc; 
        
        A11 = A(1:p,1:p); 
        A22 = A(p+1:m,p+1:m); 
        A12 = A(1:p,p+1:m); 
        A21 = A12';
        
        T = inv(A11) * A12 *  inv(A22) * A21; 
        lambda = eig(T); 
        L1(j,counter) = max(lambda)/(1-max(lambda));   % transformation to r^2/(1-r^2); 
    end
end


%%

alpha = 0.01; 
L1_0_sorted = sort(L1(1,:),'descend'); 
threshold1 = L1_0_sorted(round(iter*alpha)); 

alpha = 0.05; 
threshold5 = L1_0_sorted(round(iter*alpha)); 

for k=1:n_rho
    Pd_Sim1(k) = sum(L1(k,:)>threshold1) / iter; 
    Pd_Sim5(k) = sum(L1(k,:)>threshold5) / iter; 
end

%%
for j=2:n_rho
    fprintf('Computing theoretical power at rho=%4.2f\n',rho_arr(j)); 
    Pd_Th1(j) = 1- cdf_Roys_Test_CCA(threshold1,p,q,N,rho_arr(j)); 
    Pd_Th5(j) = 1- cdf_Roys_Test_CCA(threshold5,p,q,N,rho_arr(j)); 
end
    

file_name = strcat('table4_p',num2str(p),'_q',num2str(q),'.mat'); 
save(file_name); 

%%
for k=2:n_rho
    fprintf('%4.0f & %4.0f & %4.0f & %4.2f & %4.3f &  %4.3f &  %4.3f &  %4.3f \\\\ \n',p,q,n,rho_arr(k),Pd_Sim1(k),Pd_Th1(k),Pd_Sim5(k),Pd_Th5(k)); 
end
