function [cdf_R ] = cdf_Roys_Test_CCA(x,p,q,N,rho)
%function [cdf_R ] = cdf_Roys_Test_CCA(x,p,q,N,rho)
%
% WRITTEN BY BOAZ NADLER / 2015
%
% compute cdf ofRoy's Largest Root test statistic in
% Canonical Correlation Analysis
% with a single population canonical correlation rho

% N = total number of samples (= n+1)

m = p + q ; % m = overall dimension

n = N-1; 

NU = n-p-q; 

c1 = q/ (NU+1); c2 = (p-1) / (NU+2);
c3 = (p-1) / (NU * (NU-1));

% first compute density of central F_d1,d2
d1 = p-1; d2 = (NU+2); 
mu = d2 / (d2-2); 
std2 = 2*d2^2 * (d1+d2-2) / ( d1 * (d2-2)^2 * (d2-4) ); 
sigma = sqrt(std2); 

num_sigma = 10; 
tmin = mu - num_sigma * sigma;   tmin = max(tmin,0); 
tmax = mu + num_sigma * sigma; 

    n_points = 1025;
    t_arr = linspace(tmin,tmax,n_points);
    dt    = t_arr(2) - t_arr(1);
    
    f = fpdf(t_arr,d1,d2);
    f = min(f,1/sqrt(dt));   % this is needed only near the origin for t=0
                             % with d1=1, then chi2 density is infinite at
                             % zero, explodes like 1/sqrt(x). 

% now compute power

nx = length(x); 
cdf_R = zeros(nx,1);

for j=1:nx
    c = rho^2 / (1-rho^2); 
    a = q;
    b = n-p-q+1; 
    v = cdf_XF((x(j)-c2*t_arr-c3)/c1,a,b,c,n); 
    g     = f.*v;
    cdf_R(j) = (sum(g)-1/2*(g(1)+g(end) ) ) * dt  ; 
end

