function [cdf_R ] = cdf_Roys_Test_MANOVA(x,p,n,m,delta)
%function [cdf_R ] = cdf_Roys_Test_MANOVA(x,p,n,m,delta)
%
% Written by Boaz Nadler / 2015
%
% Here we compute L1 ( E^{-1} H ) = root of un-normalized
% covariance matrices 
%
% INPUT:
% x     = array of values at which to determine Pr[ L1 < x] 
% p     = number of groups
% n     = total number of observations
% m     = dimension of data

nH = p-1; 
nE = n-p; 

NU = nE - m ; 

c1 = nH    / (NU+1); 
c2 = (m-1) / (NU+2); 
c3 = (m-1) /( NU * (NU-1) ); 

% distribution is c1 * F_nH,nE-m+1(delta) + c2 * F_nH,nE-m+2 + c3
d1 = nH; d2 = (nE-m+2); 
mu = d2 / (d2-2);       %this is the mean of the second F r.v. 
std2 = 2*d2^2 * (d1+d2-2) / ( d1 * (d2-2)^2 * (d2-4) ); 
sigma = sqrt(std2);     %this is the standard deviation

num_sigma = 10; 
tmin = mu - num_sigma * sigma;   tmin = max(tmin,0); 
tmax = mu + num_sigma * sigma; 

    n_points = 4097;
    t_arr = linspace(tmin,tmax,n_points);
    dt    = t_arr(2) - t_arr(1);
    
    f = fpdf(t_arr,d1,d2);         % density of second F
    
    cdf_R = zeros(length(x),1); 
    
    nx = length(x); 
    for k=1:nx
        %fprintf('k = %d\n',k);         
         h     = ncfcdf( max((x(k)-c3-c2*t_arr) / (c1),0) ,nH,nE-m+1,delta);
         g     = f .*h;
         cdf_R(k) =(sum(g)-1/2*(g(1)+g(end) ) ) * dt ;
    end
    
