function [H E X] = generate_data_MANOVA(m,p,ni,delta)
%function [H E X] = generate_data_MANOVA(m,p,ni,delta)
%
% WRITTEN BY BOAZ NADLER, 2011
% 
% Generate multivariate data p groups, ni samples/group, ni  is a scalar, all groups have equal sizes. 
% where the non-centrality matrix is rank one with eigenvalue delta (concentrated non-centrality). 
%
% INPUT: 
% m     = dimension of data
% p     = number of groups
% ni    = number of samples / group
% delta = non-centrality parameter
%
% OUTPUT:
% E,H   = m by m matrices containing the within covariance and between group covariance. 
% X     = the original data of size n by m. 


n_total = ni * p;    % total number of samples

%% generate random effects + normalize so that non-centrality parameter is delta. 
si = randn(1,p); s_bar = 1/n_total * sum(ni*si); var_s = sum( ni * (si-s_bar).^2 ); 

factor = delta / var_s; 

si = si * sqrt(factor); 
s_bar = 1/n_total * sum(ni*si); 
var_s = sum( ni * (si-s_bar).^2 ); 

%fprintf('delta %f var_s %f\n',delta,var_s); 

X = randn(n_total,m);  % first generate the noise

mu_bar = zeros(p,m);     mu_mean = zeros(1,m); 

for i=1:p
    idx = ((i-1)*ni+1):i*ni; 
    X(idx,1) = X(idx,1) + si(i);    % add signal strength to first direction
    mu_bar(i,:) = mean(X(idx,:)); 
end

mu_mean = mean(X); 


E = zeros(m,m); H = zeros(m,m);             
    
%% matrix H of MANOVA, no division by number of samples
for i=1:p
    H  = H + ni * (mu_bar(i,:)-mu_mean)' * (mu_bar(i,:)-mu_mean) ; 
end


%% matrix E of MANOVA, no division by number of samples
for i=1:p 
        idx = ((i-1)*ni+1):i*ni; 
        Xc = X(idx,:) - repmat(mu_bar(i,:),ni,1);   % mean centering the data
        E = E + Xc' * Xc; 
end
