function [H, E, Xh, Xe] = generate_data_SD(m,nH,nE,lambda,sigma)
%function [H, E, Xh, Xe] = generate_data_SD(m,nH,nE,lambda,sigma)
%
%
%OUTPUT:
%       H = un-normalized covariance matrix
%       E = un-normalized noise-only covariance matrix

Xe = sigma * randn(nE,m); 

E = Xe' * Xe; 

Xh = sigma * randn(nH,m); 

Xsignal = zeros(nH,m); 
Xsignal(:,1) = sqrt(lambda) * randn(nH,1); 

Xh = Xh + Xsignal; 

H = Xh' * Xh;

