% generate the plots in figures 1 and 2 of paper by Johnstone and Nadler, 2015. 

seed = 1; randn('state',seed); 

m  =5; 
n_E=35; 
n_H=4;  p = n_H + 1; ni = 8; 

lambda_H = 10; sigma = 1; 
delta = lambda_H*n_H; 

iter = 500000; 

H1_SD = zeros(iter,1); 
L1_SD = zeros(iter,1); 

H1_M = zeros(iter,1); 
L1_M = zeros(iter,1); 

% simulation part, generate the data
for counter = 1:iter
    
    % cases 1 and 3 
    [H, E] = generate_data_SD(m,n_H,n_E,lambda_H,sigma); 
    
    eig_H = eig(H);
    Einv = inv(E);
    eig_L = eig(Einv*H); 
   
    H1_SD(counter) = max(eig_H); 
    L1_SD(counter) = max(eig_L); 
    
    % cases 2 and 4
    [H, E] = generate_data_MANOVA(m,p,ni,delta); 
    
    eig_H = eig(H);
    Einv = inv(E);
    eig_L = eig(Einv*H); 
   
    H1_M(counter) = max(eig_H); 
    L1_M(counter) = max(eig_L); 

    if mod(counter,1000)==0
        fprintf('counter %d/%d\n',counter,iter); 
    end
end
    
%% THEORETICAL CALCULATIONS OF MEAN AND VARIANCE FOR CASE1/3
NU = n_E - m ;
a1 = n_H; b1 = NU+1; a2 = (m-1); b2 = NU + 2; 
c1 = a1/b1; c2 = a2/b2; c3 = a2 / (NU * (NU-1) ); 

% distribution is c1 F_a1,b1 (delta) + c2 F_a2,b2 + c3
E_H1_SD = a1 + n_H*lambda_H + a2 + a2*(a1-1) /((a1-2)*(lambda_H+1)) ; 
V_H1_SD = (lambda_H+1)^2 * 2 * n_H + 2 * (m-1); 

E_L1_SD = c1 * (1+lambda_H)*b1/(b1-2) + c2 * b2/(b2-2) + c3; 
V_L1_SD = 2*c1^2*(1+lambda_H)^2*b1^2*(a1+b1-2)/a1/(b1-2)^2/(b1-4) +...
    2*c2^2*b2^2*(a2+b2-2)/a2/(b2-2)^2/(b2-4); 

fprintf('ONE-MATRIX CASE THEORY: %8f %8f SIM %5f %5f\n',E_H1_SD,sqrt(V_H1_SD),mean(H1_SD),std(H1_SD)); 


%% THEORETICAL CALCULATIONS OF MEAN AND VARIANCE FOR CASE 2/4

% distribution is c1 F_a1,b1 (delta) + c2 F_a2,b2 + c3
E_H1_MANOVA = a1 + delta + a2 + a2*(a1-1) /(a1-2+delta) ; 
V_H1_MANOVA = 2*(a1+a2+2*delta); 

E_L1_MANOVA = c1 * b1/(b1-2) *(a1+delta)/a1 + c2 * b2/(b2-2) + c3; 
V_L1_MANOVA = c1^2 * 2 * (b1/a1)^2* ((a1+delta)^2+(a1+2*delta)*(b1-2) )/( (b1-2)^2 *(b1-4)) + c2^2*2*b2^2* (a2+b2-2)/( a2 * (b2-2)^2 *(b2-4));

fprintf('MANOVA ONE-MATRIX THEORY: %8f %8f SIM %5f %5f\n',E_H1_MANOVA,sqrt(V_H1_MANOVA),mean(H1_M),std(H1_M)); 
fprintf('MANOVA TWO-MATRIX THEORY: %8f %8f SIM %5f %5f\n',E_L1_MANOVA,sqrt(V_L1_MANOVA),mean(L1_M),std(L1_M)); 


%% Histogram of H1 SP
NBINS = 48;
z = linspace(-3,5,NBINS);         dz = z(2)-z(1);
val_H = H1_SD(1:counter) - E_H1_SD;
val_H = val_H / sqrt(V_H1_SD);
f_H = hist(val_H,z); f_H = f_H / counter ;

x_min = E_H1_SD + min(z)*sqrt(V_H1_SD); 
x_max = E_H1_SD + max(z)*sqrt(V_H1_SD); 

x = linspace(x_min,x_max,NBINS); 

pdf_th =  pdf_Roy_H_Central(x,n_H,m,lambda_H); 


%%
figure(1); clf; set(gca,'fontsize',20); 
plot(z,f_H/dz,'bo-','markersize',10);  hold on;
plot(z,pdf_th*sqrt(V_H1_SD),'k-','linewidth',2); 
plot(z,exp(-z.^2/2)/sqrt(2*pi),'r--','linewidth',2);
legend('Sim','Theory','Gaussian'); 
axis([-3 4.5 0 0.60]); 
xlabel('$(\ell_1-E(\ell_1))/\sigma(\ell_1)$','interpreter','latex'); 
grid on; 
drawnow; 
print -depsc hist_h1_SP.eps


%% Histogram of H1_M
NBINS = 48;
z = linspace(-3,5,NBINS);         dz = z(2)-z(1);
val_H = H1_M(1:counter) - E_H1_MANOVA;
val_H = val_H / sqrt(V_H1_MANOVA);
f_H = hist(val_H,z); f_H = f_H / counter ;

x_min = E_H1_MANOVA + min(z)*sqrt(V_H1_MANOVA); 
x_max = E_H1_MANOVA + max(z)*sqrt(V_H1_MANOVA); 

x = linspace(x_min,x_max,NBINS); 

pdf_th =  pdf_Roy_H_NonCentral(x,n_H,m,delta); 


%%
figure(2); clf; set(gca,'fontsize',20); 
plot(z,f_H/dz,'bo-','markersize',10);  hold on;
plot(z,pdf_th*sqrt(V_H1_MANOVA),'k-','linewidth',2); 
plot(z,exp(-z.^2/2)/sqrt(2*pi),'r--','linewidth',2);
legend('Sim','Theory','Gaussian'); 
axis([-3 4.5 0 0.60]); 
xlabel('$(\ell_1-E(\ell_1))/\sigma(\ell_1)$','interpreter','latex'); 
grid on; 
drawnow; 
print -depsc hist_h1_MANOVA.eps




%% Histogram of L1 SD
NBINS = 48;
z = linspace(-2.5,5,NBINS);         dz = z(2)-z(1);
val_H = L1_SD(1:counter) - E_L1_SD;
val_H = val_H / sqrt(V_L1_SD);
f_H = hist(val_H,z); f_H = f_H / counter ;

x_min = E_L1_SD + min(z)*sqrt(V_L1_SD); 
x_max = E_L1_SD + max(z)*sqrt(V_L1_SD); 

x = linspace(x_min,x_max,NBINS); 

pdf_th = pdf_Roy_EinvH_Central(x,n_H,n_E,m,lambda_H); 

figure(3); clf; set(gca,'fontsize',20); 
plot(z,f_H/dz,'bo-','markersize',10);  hold on;
plot(z,pdf_th*sqrt(V_L1_SD),'k-','linewidth',2); 
plot(z,exp(-z.^2/2)/sqrt(2*pi),'r--','linewidth',2);
legend('Sim','Theory','Gaussian'); 
axis([-2.5 4.5 0 0.70]); 
xlabel('$(\ell_1-E(\ell_1))/\sigma(\ell_1)$','interpreter','latex'); 
grid on; 
drawnow; 
print -depsc hist_L1_SP.eps

%%

%% Histogram of L1 M
NBINS = 48;
z = linspace(-2.5,5,NBINS);         dz = z(2)-z(1);
val_H = L1_M(1:counter) - E_L1_MANOVA;
val_H = val_H / sqrt(V_L1_MANOVA);
f_H = hist(val_H,z); f_H = f_H / counter ;

x_min = E_L1_MANOVA + min(z)*sqrt(V_L1_MANOVA); 
x_max = E_L1_MANOVA + max(z)*sqrt(V_L1_MANOVA); 

x = linspace(x_min,x_max,NBINS); 

pdf_th = pdf_Roy_EinvH_NonCentral(x,n_H,n_E,m,delta); 

figure(4); clf; set(gca,'fontsize',20); 
plot(z,f_H/dz,'bo-','markersize',10);  hold on;
plot(z,pdf_th*sqrt(V_L1_MANOVA),'k-','linewidth',2); 
plot(z,exp(-z.^2/2)/sqrt(2*pi),'r--','linewidth',2);
legend('Sim','Theory','Gaussian'); 
axis([-2.5 4.5 0 0.70]); 
xlabel('$(\ell_1-E(\ell_1))/\sigma(\ell_1)$','interpreter','latex'); 
grid on; 
drawnow; 
%print -depsc hist_L1_MANOVA.eps
