% script to recover table 1
% run with rho = 0 or with rho = 0.3 

rho = 0.3;

p=6;  % number of groups
m=6; % dimension / number of variables

ni=20;% number of samples/group

 
iter = 1000000; 

mu_0 = ones(m,1); 
mu_0(1:m/2) = -1; 

Sigma = (1-rho)*eye(m) + rho * ones(m,1)*ones(1,m);

tau = [0.09 0.11 0.13];

mu_array = zeros(p,m); 
for i=1:p
    mu_array(i,:) = i*mu_0;
end

L1_0 = zeros(iter,1); L1_1 = zeros(iter,1);  
L1_2 = zeros(iter,1); L1_3 = zeros(iter,1);  

P_0 = zeros(iter,1); P_1 = zeros(iter,1);  
P_2 = zeros(iter,1); P_3 = zeros(iter,1);  

for counter=1:iter
    
    if mod(counter,2000)==0 
        fprintf('counter %d\n',counter); 
    end
    
    % first only noise; 
    mu_array0 = 0*mu_array; 
    [E H X] = generate_data_anova(m,p,ni,mu_array0,Sigma); 
    Einv = inv(E); 
    lambda = real(eig(Einv*H)); 
    L1_0(counter) = max(lambda);
    P_0(counter)  = sum(lambda./(1+lambda));
    
% first tau
    mu_array1 = tau(1)*mu_array; 
    [E H X] = generate_data_anova(m,p,ni,mu_array1,Sigma); 
    Einv = inv(E); 
    lambda = real(eig(Einv*H)); 
    L1_1(counter) = max(lambda);
    P_1(counter)  = sum(lambda./(1+lambda));

% second tau
    mu_array1 = tau(2)*mu_array; 
    [E H X] = generate_data_anova(m,p,ni,mu_array1,Sigma); 
    Einv = inv(E); 
    lambda = real(eig(Einv*H)); 
    L1_2(counter) = max(lambda);
    P_2(counter)  = sum(lambda./(1+lambda));

% third tau
    mu_array1 = tau(3)*mu_array; 
    [E H X] = generate_data_anova(m,p,ni,mu_array1,Sigma); 
    Einv = inv(E); 
    lambda = real(eig(Einv*H)); 
    L1_3(counter) = max(lambda);
    P_3(counter)  = sum(lambda./(1+lambda));
end

%%
alpha = 0.01; 
L1_0_sorted = sort(L1_0,'descend'); 
threshold = L1_0_sorted(round(iter*alpha)); 

power_R_1 = sum(L1_1 > threshold) / iter; 
power_R_2 = sum(L1_2 > threshold) / iter; 
power_R_3 = sum(L1_3 > threshold) / iter; 

fprintf('----------------------------\n');
fprintf('Roy:    %4.2f %4.2f %4.2f\n',power_R_1,power_R_2,power_R_3); 

P_0_sorted = sort(P_0,'descend'); 
threshold_P = P_0_sorted(round(iter*alpha)); 

power_P_1 = sum(P_1 > threshold_P) / iter; 
power_P_2 = sum(P_2 > threshold_P) / iter; 
power_P_3 = sum(P_3 > threshold_P) / iter; 

fprintf('Pillai: %4.2f %4.2f %4.2f\n',power_P_1,power_P_2,power_P_3); 

%%
% Theoretical power calculations of Roy's test, using Prop. 4
%
mu_bar = mean(mu_array,1);  % 1 x m vector;
Omega = zeros(m,m); 
for i=1:p
    Omega = Omega + ni * (mu_array(i,:)-mu_bar)' * (mu_array(i,:)-mu_bar);
end
Omega = inv(Sigma) * Omega; 
lambda = eig(Omega); delta = max(lambda); 
% lambda is the non-centrality parameter, up to scaling by tau^2 

[cdf_1 ] = cdf_Roys_Test_MANOVA(threshold,p,ni*p,m,delta*tau(1)^2);
[cdf_2 ] = cdf_Roys_Test_MANOVA(threshold,p,ni*p,m,delta*tau(2)^2);
[cdf_3 ] = cdf_Roys_Test_MANOVA(threshold,p,ni*p,m,delta*tau(3)^2);

fprintf('Pd R  %4.2f %4.2f %4.2f\n',1-cdf_1,1-cdf_2,1-cdf_3);
