function [Px ] = cdf_XF(x,a,b,c,n)
%function [Px ] = cdf_XF(x,a,b,c,n)
%
% WRITTEN BY BOAZ NADLER / 2011
%
% Cummulative Distribution Function of F_{a,b}(delta) where delta itself is a r.v with distribution 
% delta = c * chi^2_n
%
% Pr[ XF < x] = int  ncfcdf(x,a,b,c*t) * chi2_n(t) dt
% p [ XF = x] = int  ncfpdf(x,a,b,c*t) * chi2_n(t) dt
%


if nargin~=5
    help cdf_XF; 
    return; 
end

num_t    = 1025; % number of discretization points
num_std  = 8;    % number of standard deviations for numerical integration interval, where f_nu2 is non-zero

t_center = n; 
t_std    = sqrt(2*n); 
t_max    = max(t_center + num_std * t_std,0);
t_min    = max(t_center - num_std * t_std,0);
t_arr    = linspace(t_min,t_max,num_t); 

dt = t_arr(2) - t_arr(1); 

nx = length(x); 
Px = zeros(1,nx); 

chi2n = chi2pdf(t_arr,n); 

for j=1:nx
    z = x(j); 
    g = ncfcdf(z,a,b,c*t_arr) .* chi2n; 
    Px(j) = ( sum(g)-1/2*(g(1)+g(end) ) ) * dt ;   %trapezoidal rule
end
