function [E H X] = generate_data_anova(m,p,ni,mu_array,Sigma)
%function [E H X] = generate_data_anova(m,p,ni,mu_array,Sigma)
%
% written by Boaz Nadler, 2015
%
% m = dimension; 
% p = number of groups; 
% ni= number of samples/group (all groups have same number of samples)
% mu_array = matrix of size p x m of means of different groups
% Sigma = m x m covariance matrix of the noise
%
% OUTPUT:
%  E,H   = m by m matrices containing the within covariance and between group covariance. 
%  X     = the original data of size n by m. 

n = ni * p; 
X = zeros(n,m);

E = zeros(m,m); H = zeros(m,m);

% first generate the noise; 
X = mvnrnd(X,Sigma);

mu_bar = zeros(p,m);     % the empirical means in the p groups
mu_mean = zeros(1,m);    % the overall mean

% next go over the p groups and add the mean vector
for i=1:p
    idx = ((i-1)*ni+1):i*ni; 
    X(idx,:) = X(idx,:) + repmat(mu_array(i,:),ni,1);    
    mu_bar(i,:) = mean(X(idx,:)); 
end

mu_mean = mean(X); 

%% matrix H of MANOVA, no division by number of samples
for i=1:p
    H  = H + ni * (mu_bar(i,:)-mu_mean)' * (mu_bar(i,:)-mu_mean) ; 
end

%% matrix E of MANOVA, no division by number of samples
for i=1:p 
        idx = ((i-1)*ni+1):i*ni; 
        Xc = X(idx,:) - repmat(mu_bar(i,:),ni,1);   % mean centering the data
        E = E + Xc' * Xc; 
end

E = (E + E')/2; H = (H+H')/2;  