function [pdf_R ] = pdf_Roy_EinvH_Central(x,nH,nE,m,lambda)
%function [pdf_R ] = pdf_Roy_EinvH_Central(x,nH,nE,m,lambda)
%
% WRITTEN BY Boaz Nadler / 2015
%
% INPUT:
% x     = array of values at which to determine d/dx Pr[ L1 < x] 
% nH    = number of signal bearing observations
% nE    = number of noise only observations
% m     = dimension of data
% lambda= signal strength

NU = nE - m ; 

a1 =nH; a2 = m-1; b1 = NU+1; b2 = NU+2; 

c1 = a1 / b1; 
c2 = a2 / b2; 
c3 = a2 / ( NU * (NU-1) ); 

% distribution is (lambda+1)*c1 * F_a1,b1 + c2 * F_a1,b2 + c3

d1 = a2; d2 = b2; 
mu = d2 / (d2-2);  % mean of second F r.v.  
std2 = 2*d2^2 * (d1+d2-2) / ( d1 * (d2-2)^2 * (d2-4) ); % std of second F r.v.
sigma = sqrt(std2); 

num_sigma = 8; 
tmin = mu - num_sigma * sigma;   tmin = max(tmin,0); 
tmax = mu + num_sigma * sigma; 

    n_points = 4097;
    t_arr = linspace(tmin,tmax,n_points);
    dt    = t_arr(2) - t_arr(1);
    
    f = fpdf(t_arr,d1,d2);
    
    nx = length(x); 
    pdf_R = zeros(nx,1); 
    
    for k=1:nx
         h     = fpdf( max((x(k)-c3-c2*t_arr) / (c1*(1+lambda)),0),a1,b1);
         g     = f .*h / (c1*(1+lambda));
         pdf_R(k) =(sum(g)-1/2*(g(1)+g(end) ) ) * dt ;
    end
