close all;
addpath('./mex/');

image.realImagePath = '../images/toy.png';
% image.realImagePath = '../images/toy_circle.png';
% image.realImagePath = '../images/foggy_road.jpg';
% image.realImagePath = '../images/bridge.png';
% image.realImagePath = '../images/fields.jpg';
% image.realImagePath = '../images/road_sky.jpg';
% image.realImagePath = '../images/corner_soccer.jpg';
% image.realImagePath = '../images/silouette.jpg';
% image.realImagePath = '../images/powerlines.jpg';

detector.suggested_sigma = -1;		% -1 means that noise level is estimated from the input
detector.mask_width = 3;		% half mask width for obtaining pixel responses
detector.quantizer = 1;			% M_q: level of quantization
detector.b_bounds = [10, 4];		% bounds on the polynomial coefficients
detector.interp_scale = 3;		% scale of linear interpolation
detector.max_scale = 5;			% maximum scale of the detection strip
detector.num_strips = 4;		% number of evenly spaced detection strips
detector.falsePositive = 1e-5;		% detection false positive
detector.trackFalsePositive = 1e-4;	% tracking false positive

% visual effect of the final output
% choose from classic, all_red, and detection_only
mode = 'classic';

% whether to perform edge detection on the transposed image
only_horizontal = false;

% run the sublinear algorithm
run_algo;

% to run the two other algorithms, comment out the following line
% run_canny_lsd;
