#include <stdbool.h>

typedef struct {
    bool is_valid;
    double value;
} optional_double;


double line_integral (
    int scale,					/* current scale ranging from 1 to interp_scale			*/
    int interp_scale,				/* interpolation scale						*/
    double max_slope,
    size_t rowl,				/* l.h.s. row coordinate of the segment				*/
    size_t rowr,				/* r.h.s. row coordinate of the segment				*/
    int recur_idx,				/* binary tree index						*/
    int substrip_id,				/* index of the substrips of the input_strip			*/
    double * input_strip,			/* actual input image strip					*/
    size_t n,					/* number of rows of input_strip				*/
    size_t start_col				/* starting column						*/
);
