% output the curves detected by Canny and LSD
% some manual adjustment of the parameters may be required

% Written by Yi-Qing Wang, 2016

addpath('../utils/');

I = double(image.noisy)/255;

tic();
cannyDetections = edge(I,'canny',[0.32 0.62]); % params for noisy images
runtime = toc();
cannyDetectionsOverlay = overlay_edges(I,cannyDetections);
disp(['Canny Runtime: ', num2str(runtime),' sec']);

cannyDetections(:, 1) = 1;
cannyDetections(:, end) = 1;
cannyDetections(end, :) = 1;
cannyDetections(1, :) = 1;
imwrite(uint8(255-cannyDetections*255), sprintf('%s_canny.png', name_str));
figure(); title('Canny'); imshow(uint8(cannyDetections* 255));

% -------------------------------------------------------------------------

addpath('../LSD/');

tic();
lsdEdgeList = lsd_mex(I, 0.17, 0.8);  % params for noisy images
runtime = toc();
edges{1} = lsdEdgeList(2,:);
edges{2} = lsdEdgeList(4,:);
edges{3} = lsdEdgeList(1,:);
edges{4} = lsdEdgeList(3,:);
[lsdDetections,~,lsdDetectionsOverlay] = visualise_edges(I,edges,cell(1,4));
disp(['LSD Runtime: ', num2str(runtime),' sec']);

lsdDetections(:, 1) = 1;
lsdDetections(:, end) = 1;
lsdDetections(end, :) = 1;
lsdDetections(1, :) = 1;
imwrite(uint8(255-lsdDetections * 255), sprintf('%s_lsd.png', name_str));
figure(); imshow(uint8(lsdDetections * 255));
