/** This code is used in the process of generating the setsystem
 * and predicate for the OWF and only the setsystem for the 
 * PRF. It uses other files for doing the real generation
 * process
 *
 */

#include "Geometric.hpp"
#include "RandomGraph.hpp"
#include "PredicateGenerator.hpp"
#include "MathFunctions.hpp"

#define klimit 20
#define maxChoice 8

  	/** File format for expanders :-
	  * --------------------------
	  * n
	  * d
	  * <collection1-in-a-column>
	  * <collection2-in-a-column>
	  * ...and so on !
	  */
	
	/** File Format for predicate :-
	  * --------------------------
	  * <choice-of-predicate>
	  * d
	  * 2^d entries (0's or 1's only) in a straight line (if choice-of-predicate is 0)
	  */
	
static int OurN, OurD;

void generateAndStoreExpander(char *genfile) {

	 FILE *fp;
	 int choice, val;
	 int test1;
	 
	 printf("\n\nEnter the kind of expanders you want to use to generate the setsystem -\n\n");
	 printf("\tTo use Geometric Expanders, enter 1\n");
	 printf("\tTo use Random Expanders, enter 2\n\n");	 	 
	 printf("Your choice here - ");

	 while (1) {
		  scanf("%d", &choice);
		  if ((choice != 1) && (choice != 2)) 
			   printf("\nInvalid Entry. Enter again - ");
		  else 
			   break;
	 }

	 switch(choice) {
		  case 1: 
			   { 
					int *ln;
					int choiceOfN[maxChoice];			   
					printf("\n\nEnter the choice for n (the length for which you want to run the function). The choices are -\n\n");

					getGeometricChoices(choiceOfN, maxChoice);

					for (int c=0; c<maxChoice; c++)
						 printf("\t%d -> %d\n", c, choiceOfN[c]);

					printf("\n");
					printf("Your choice here - ");
					while(1) {
						 scanf("%d", &choice);
						 if ((choice < 0) || (choice >= maxChoice)) 
							  printf("\nInvalid Entry. Enter again - ");
						 else 
							  break;
					}

					OurN = choiceOfN[choice];

					int collection[OurN][klimit];
					ln = (int *) malloc(sizeof(int));
					generateGeometricExpander(OurN, ln, collection);
					OurD = *ln;

					// Store expanders to file :-
					test1 = (int) fopen(genfile, "w+"); // Open file for writing
					if (!test1) {
						 printf("\nThe file for setsystem could not be opened. Make sure you are in the right directory while executing this command.\n\n");
						 exit(1);
					}
					fp = fopen(genfile, "w+"); // Open file for writing
					
					fprintf(fp, "%d\n%d\n", OurN, OurD);
					for (int n1=0; n1<OurN; n1++) {
						 for (int d1=0; d1<OurD; d1++) {
							  val = collection[n1][d1];
							  fprintf(fp, "%d\n", val);
						 }
					}
					fclose(fp);

					break;
			   }
		  case 2: 
			   {
					printf("\n\nEnter the choice for n (the length for which you want to run the function, typically between 100 and 2000).\n");
					printf("Your choice here - ");
					scanf("%d", &OurN);

					int collection[OurN][klimit];
					printf("\n\nEnter the choice for d (the degree of the expander graph desired; d should be more than 2 and less than %d).\n", klimit);
					printf("Your choice here - ");
					while(1) {
						 scanf("%d", &OurD);
						 if ((OurD <= 2) || (OurD > klimit)) 
							  printf("\nInvalid Entry. Enter again - ");
						 else 
							  break;
					}

					generateRandomExpander(OurN, OurD, collection);

					// Store expanders to file :-
					test1 = (int)fopen(genfile, "w+"); // Open file for writing
					if (!test1) {
						 printf("\nThe file for setsystem could not be opened. Make sure you are in the right directory while executing this command.\n\n");
						 exit(1);
					}
					fp = fopen(genfile, "w+"); // Open file for writing
					
					fprintf(fp, "%d\n%d\n", OurN, OurD);
					for (int n1=0; n1<OurN; n1++) {
						 for (int d1=0; d1<OurD; d1++) {
							  val = collection[n1][d1];
							  fprintf(fp, "%d\n", val);
						 }
					}
					fclose(fp);

					break;
			   }
	 }
}

void generateAndStorePredicate(char *genfile, char *predfile) {
	 
	 FILE *fp;
	 int power;
	 int choice, val;
	 int test1;
	 
	 // Predicate depends on the value of d. Read it from the file
	 
	 test1 = (int)fopen(genfile, "r"); // Open file for writing
	 if (!test1) {
		  printf("\nThe file for setsystem could not be opened. Make sure you are in the right directory while executing this command.\n\n");
		  exit(1);
	 }	 
	 fp = fopen(genfile, "r");
	 
	 fscanf(fp, "%d\n%d\n", &OurN, &OurD);
	 fclose(fp);

	 printf("\n\nEnter the kind of predicate you want to hard-wire into the function. The choices are - \n\n"); 

	 printf("\t0 -> Random Predicate\n");
	 printf("\t1 -> Using a (random) d-variant 2-degree polynomial as the predicate (ref. documentation)\n");
	 printf("\t2 -> Using the Inner Product for predicate (ref. documentation)\n\n");

	 printf("Your choice here - ");
	 while(1) {
		  scanf("%d", &choice);
		  if ((choice != 0) && (choice != 1) && (choice != 2)) 
			   printf("\nDon't fool around ! Enter a valid choice - ");
		  else 
			   break;
	 }

	 printf("\n");

	 switch(choice) {
		  case 0 : {
						power = (int) pow(2.0, (double)OurD);
						char predicate[power];

						givePredicate(power, predicate);
						
						test1 = (int)fopen(predfile, "w+"); // Open file for writing
						if (!test1) {
							 printf("\nThe file for predicate could not be opened. Make sure you are in the right directory while executing this command.\n\n");
							 exit(1);
						}

						fp = fopen(predfile, "w+");
						
						fprintf(fp, "%d\n", 0);
						fprintf(fp, "%d\n", OurD);
						char pred;
						for (int n1=0; n1<power; n1++) {
							 pred = predicate[n1];
							 fprintf(fp, "%c\n", pred);
						}
						fclose(fp);
						break;
				   }
		  case 1 :
				   {
						power = choose(OurD, 2);	
						char polynomial[power];
						givePredicate(power, polynomial);
						
						test1 = (int)fopen(predfile, "w+"); // Open file for writing
						if (!test1) {
							 printf("\nThe file for predicate could not be opened. Make sure you are in the right directory while executing this command.\n\n");
							 exit(1);
						}
						fp = fopen(predfile, "w+");
						
						fprintf(fp, "%d\n", 1);
						fprintf(fp, "%d\n", OurD);
						char pred;
						for (int n1=0; n1<power; n1++) {
							 pred = polynomial[n1];
							 fprintf(fp, "%c\n", pred);
						}
						fclose(fp);
						break;
				   }
		  case 2 :
				   test1 = (int)fopen(predfile, "w+"); // Open file for writing
				   if (!test1) {
						printf("\nThe file for predicate could not be opened. Make sure you are in the right directory while executing this command.\n\n");
						exit(1);
				   }
				   fp = fopen(predfile, "w+");
				   
				   fprintf(fp, "%d\n", 2);
				   fprintf(fp, "%d\n", OurD);
				   fclose(fp);
				   break;
	 }
}

